/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;

public class TestAddAttributeFromOMAttributeMultiple
extends AxiomTestCase {
    public TestAddAttributeFromOMAttributeMultiple(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        String expectedXML = "<AttributeTester xmlns=\"\" xmlns:myAttr2NS=\"http://test-attributes-2.org\" xmlns:myAttr1NS=\"http://test-attributes-1.org\" myAttr2NS:attrNumber=\"2\" myAttr1NS:attrNumber=\"1\" />";
        OMFactory omFactory = this.metaFactory.getOMFactory();
        OMNamespace attrNS1 = omFactory.createOMNamespace("http://test-attributes-1.org", "myAttr1NS");
        OMNamespace attrNS2 = omFactory.createOMNamespace("http://test-attributes-2.org", "myAttr2NS");
        OMElement omElement = omFactory.createOMElement("AttributeTester", null);
        omElement.addAttribute(omFactory.createOMAttribute("attrNumber", attrNS1, "1"));
        omElement.addAttribute(omFactory.createOMAttribute("attrNumber", attrNS2, "2"));
        int nsCount = 0;
        Iterator iterator = omElement.getAllDeclaredNamespaces();
        while (iterator.hasNext()) {
            iterator.next();
            ++nsCount;
        }
        TestAddAttributeFromOMAttributeMultiple.assertTrue((nsCount == 2 ? 1 : 0) != 0);
        Diff diff = XMLUnit.compareXML((String)expectedXML, (String)omElement.toString());
        XMLAssert.assertXMLEqual((Diff)diff, (boolean)true);
    }
}

