/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestAddChildWithSameParent
extends AxiomTestCase {
    private final boolean build;

    public TestAddChildWithSameParent(OMMetaFactory metaFactory, boolean build) {
        super(metaFactory);
        this.build = build;
        this.addTestProperty("build", String.valueOf(build));
    }

    protected void runTest() throws Throwable {
        OMElement parent = AXIOMUtil.stringToOM((OMFactory)this.metaFactory.getOMFactory(), (String)"<parent><a/><b/><c/></parent>");
        if (this.build) {
            parent.build();
        }
        OMElement b = (OMElement)parent.getFirstOMChild().getNextOMSibling();
        parent.addChild((OMNode)b);
        OMElement child = (OMElement)parent.getFirstOMChild();
        TestAddChildWithSameParent.assertEquals((String)"a", (String)child.getLocalName());
        child = (OMElement)child.getNextOMSibling();
        TestAddChildWithSameParent.assertEquals((String)"c", (String)child.getLocalName());
        child = (OMElement)child.getNextOMSibling();
        TestAddChildWithSameParent.assertSame((Object)child, (Object)b);
        TestAddChildWithSameParent.assertNull((Object)child.getNextOMSibling());
        TestAddChildWithSameParent.assertSame((Object)parent, (Object)b.getParent());
    }
}

