/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetAllDeclaredNamespacesRemove
extends AxiomTestCase {
    public TestGetAllDeclaredNamespacesRemove(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement element = factory.createOMElement("test", null);
        element.declareNamespace("urn:a", "a");
        element.declareNamespace("urn:b", "b");
        element.declareNamespace("urn:c", "c");
        Iterator it = element.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            if (!ns.getPrefix().equals("b")) continue;
            it.remove();
            break;
        }
        TestGetAllDeclaredNamespacesRemove.assertEquals((String)"urn:a", (String)element.findNamespaceURI("a").getNamespaceURI());
        TestGetAllDeclaredNamespacesRemove.assertNull((Object)element.findNamespaceURI("b"));
        TestGetAllDeclaredNamespacesRemove.assertEquals((String)"urn:c", (String)element.findNamespaceURI("c").getNamespaceURI());
    }
}

