/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetDescendants
extends AxiomTestCase {
    private final boolean includeSelf;

    public TestGetDescendants(OMMetaFactory metaFactory, boolean includeSelf) {
        super(metaFactory);
        this.includeSelf = includeSelf;
        this.addTestProperty("includeSelf", Boolean.toString(includeSelf));
    }

    protected void runTest() throws Throwable {
        OMElement element = AXIOMUtil.stringToOM((OMFactory)this.metaFactory.getOMFactory(), (String)"<root><a><b><c><d/><e/></c></b><f/></a><g/></root>");
        Iterator it = element.getFirstElement().getDescendants(this.includeSelf);
        if (this.includeSelf) {
            TestGetDescendants.assertEquals((String)"a", (String)((OMElement)it.next()).getLocalName());
        }
        TestGetDescendants.assertEquals((String)"b", (String)((OMElement)it.next()).getLocalName());
        TestGetDescendants.assertEquals((String)"c", (String)((OMElement)it.next()).getLocalName());
        TestGetDescendants.assertEquals((String)"d", (String)((OMElement)it.next()).getLocalName());
        TestGetDescendants.assertEquals((String)"e", (String)((OMElement)it.next()).getLocalName());
        TestGetDescendants.assertEquals((String)"f", (String)((OMElement)it.next()).getLocalName());
        TestGetDescendants.assertFalse((boolean)it.hasNext());
    }
}

