/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetNamespaceContext
extends AxiomTestCase {
    private final boolean detached;

    public TestGetNamespaceContext(OMMetaFactory metaFactory, boolean detached) {
        super(metaFactory);
        this.detached = detached;
        this.addTestProperty("detached", Boolean.toString(detached));
    }

    protected void runTest() throws Throwable {
        InputStream in = TestGetNamespaceContext.class.getResourceAsStream("namespacecontext.xml");
        OMElement root = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (InputStream)in).getDocumentElement();
        OMElement inner = root.getFirstElement().getFirstElement();
        NamespaceContext context = inner.getNamespaceContext(this.detached);
        TestGetNamespaceContext.assertEquals((String)"urn:test2", (String)context.getNamespaceURI("p"));
        TestGetNamespaceContext.assertEquals((String)"urn:test3", (String)context.getNamespaceURI("q"));
        TestGetNamespaceContext.assertEquals((String)"urn:test3", (String)context.getNamespaceURI("r"));
        TestGetNamespaceContext.assertEquals((String)"urn:test4", (String)context.getNamespaceURI(""));
        TestGetNamespaceContext.assertEquals((String)"", (String)context.getNamespaceURI("unbound"));
        TestGetNamespaceContext.assertNull((Object)context.getPrefix("urn:test1"));
        TestGetNamespaceContext.assertEquals((String)"p", (String)context.getPrefix("urn:test2"));
        String prefix = context.getPrefix("urn:test3");
        TestGetNamespaceContext.assertTrue((prefix.equals("q") || prefix.equals("r") ? 1 : 0) != 0);
        TestGetNamespaceContext.assertEquals((String)"", (String)context.getPrefix("urn:test4"));
        TestGetNamespaceContext.assertNull((Object)context.getPrefix("unbound"));
        Iterator<String> it = context.getPrefixes("urn:test1");
        TestGetNamespaceContext.assertFalse((boolean)it.hasNext());
        it = context.getPrefixes("urn:test2");
        TestGetNamespaceContext.assertTrue((boolean)it.hasNext());
        TestGetNamespaceContext.assertEquals((Object)"p", (Object)it.next());
        TestGetNamespaceContext.assertFalse((boolean)it.hasNext());
        it = context.getPrefixes("urn:test3");
        HashSet<String> prefixes = new HashSet<String>();
        while (it.hasNext()) {
            prefixes.add(it.next());
        }
        TestGetNamespaceContext.assertEquals((int)2, (int)prefixes.size());
        TestGetNamespaceContext.assertTrue((boolean)prefixes.contains("q"));
        TestGetNamespaceContext.assertTrue((boolean)prefixes.contains("r"));
    }
}

