/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.StringReader;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.container.BuilderFactory;
import org.xml.sax.InputSource;

public class TestGetXMLStreamReaderCommentEvent
extends AxiomTestCase {
    private final BuilderFactory builderFactory;
    private final boolean cache;

    public TestGetXMLStreamReaderCommentEvent(OMMetaFactory metaFactory, BuilderFactory builderFactory, boolean cache) {
        super(metaFactory);
        this.builderFactory = builderFactory;
        this.cache = cache;
        builderFactory.addTestProperties(this);
        this.addTestProperty("cache", Boolean.toString(cache));
    }

    protected void runTest() throws Throwable {
        OMXMLParserWrapper builder = this.builderFactory.getBuilder(this.metaFactory, new InputSource(new StringReader("<a><!--comment text--></a>")));
        OMElement element = builder.getDocumentElement();
        XMLStreamReader reader = element.getXMLStreamReader(this.cache);
        TestGetXMLStreamReaderCommentEvent.assertEquals((int)1, (int)reader.next());
        TestGetXMLStreamReaderCommentEvent.assertEquals((int)5, (int)reader.next());
        TestGetXMLStreamReaderCommentEvent.assertEquals((String)"comment text", (String)reader.getText());
        TestGetXMLStreamReaderCommentEvent.assertEquals((String)"comment text", (String)new String(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength()));
        StringBuffer text = new StringBuffer();
        char[] buf = new char[5];
        int sourceStart = 0;
        while (true) {
            int nCopied = reader.getTextCharacters(sourceStart, buf, 0, buf.length);
            text.append(buf, 0, nCopied);
            if (nCopied < buf.length) break;
            sourceStart += buf.length;
        }
        TestGetXMLStreamReaderCommentEvent.assertEquals((String)"comment text", (String)text.toString());
        element.close(false);
    }
}

