/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderGetNamespaceContext
extends AxiomTestCase {
    private final boolean cache;

    public TestGetXMLStreamReaderGetNamespaceContext(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestProperty("cache", Boolean.toString(cache));
    }

    protected void runTest() throws Throwable {
        OMElement element = AXIOMUtil.stringToOM((OMFactory)this.metaFactory.getOMFactory(), (String)"<a xmlns='urn:ns1' xmlns:ns2='urn:ns2'><b xmlns:ns3='urn:ns3'/></a>");
        XMLStreamReader stream = this.cache ? element.getXMLStreamReader() : element.getXMLStreamReaderWithoutCaching();
        stream.next();
        TestGetXMLStreamReaderGetNamespaceContext.assertEquals((int)1, (int)stream.next());
        TestGetXMLStreamReaderGetNamespaceContext.assertEquals((String)"b", (String)stream.getLocalName());
        NamespaceContext context = stream.getNamespaceContext();
        TestGetXMLStreamReaderGetNamespaceContext.assertEquals((String)"urn:ns1", (String)context.getNamespaceURI(""));
        TestGetXMLStreamReaderGetNamespaceContext.assertEquals((String)"urn:ns2", (String)context.getNamespaceURI("ns2"));
        TestGetXMLStreamReaderGetNamespaceContext.assertEquals((String)"urn:ns3", (String)context.getNamespaceURI("ns3"));
        TestGetXMLStreamReaderGetNamespaceContext.assertEquals((String)"ns2", (String)context.getPrefix("urn:ns2"));
        element.close(false);
    }
}

