/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderOnNonRootElement
extends AxiomTestCase {
    private final boolean cache;

    public TestGetXMLStreamReaderOnNonRootElement(OMMetaFactory metaFactory, boolean cache) {
        super(metaFactory);
        this.cache = cache;
        this.addTestProperty("cache", Boolean.toString(cache));
    }

    protected void runTest() throws Throwable {
        OMElement root = AXIOMUtil.stringToOM((OMFactory)this.metaFactory.getOMFactory(), (String)"<a><b><c/></b></a>");
        OMElement child = (OMElement)root.getFirstOMChild();
        XMLStreamReader stream = this.cache ? child.getXMLStreamReader() : child.getXMLStreamReaderWithoutCaching();
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)7, (int)stream.getEventType());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)1, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((String)"b", (String)stream.getLocalName());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)1, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((String)"c", (String)stream.getLocalName());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)2, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)2, (int)stream.next());
        TestGetXMLStreamReaderOnNonRootElement.assertEquals((int)8, (int)stream.next());
        root.close(false);
    }
}

