/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLStreamReaderConfiguration;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetXMLStreamReaderWithPreserveNamespaceContext
extends AxiomTestCase {
    public TestGetXMLStreamReaderWithPreserveNamespaceContext(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        InputStream in = TestGetXMLStreamReaderWithPreserveNamespaceContext.class.getResourceAsStream("AXIOM-114.xml");
        OMElement root = OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (InputStream)in).getDocumentElement();
        OMXMLStreamReaderConfiguration configuration = new OMXMLStreamReaderConfiguration();
        configuration.setPreserveNamespaceContext(true);
        XMLStreamReader reader = root.getFirstElement().getFirstElement().getXMLStreamReader(true, configuration);
        TestGetXMLStreamReaderWithPreserveNamespaceContext.assertEquals((int)1, (int)reader.next());
        TestGetXMLStreamReaderWithPreserveNamespaceContext.assertEquals((int)4, (int)reader.getNamespaceCount());
        HashSet<String> prefixes = new HashSet<String>();
        for (int i = 0; i < 4; ++i) {
            prefixes.add(reader.getNamespacePrefix(i));
        }
        TestGetXMLStreamReaderWithPreserveNamespaceContext.assertEquals(new HashSet<String>(Arrays.asList("soapenv", "xsd", "xsi", "ns")), prefixes);
    }
}

