/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;

public class TestSetTextQName
extends AxiomTestCase {
    public TestSetTextQName(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement element = factory.createOMElement("TestElement", null);
        QName qname = new QName("urn:ns1", "test", "ns");
        element.setText(qname);
        boolean foundNamespace = false;
        Iterator it = element.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            if (!"urn:ns1".equals(ns.getNamespaceURI()) || !"ns".equals(ns.getPrefix())) continue;
            foundNamespace = true;
        }
        TestSetTextQName.assertTrue((String)"Namespace of the text is not defined in the parent element", (boolean)foundNamespace);
        TestSetTextQName.assertTrue((boolean)element.toString().contains("ns:test"));
        TestSetTextQName.assertEquals((String)"ns:test", (String)element.getText());
        TestSetTextQName.assertEquals((Object)qname, (Object)element.getTextAsQName());
    }
}

