/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.om.ds.WrappedTextNodeOMDataSourceFromReader;
import org.apache.axiom.testutils.suite.TestCaseEx;
import org.apache.axiom.ts.om.sourcedelement.TestDataSource;

public abstract class OMSourcedElementVariant {
    public static final OMSourcedElementVariant[] INSTANCES = new OMSourcedElementVariant[]{new OMSourcedElementVariant("qname-aware-source", false, false, false){

        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            return factory.createOMElement((OMDataSource)new WrappedTextNodeOMDataSourceFromReader(qname, (Reader)new StringReader("test")));
        }
    }, new OMSourcedElementVariant("unknown-name", true, true, true){

        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            OMElement orgElement = factory.createOMElement(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
            return factory.createOMElement((OMDataSource)new TestDataSource(orgElement.toString()));
        }
    }, new OMSourcedElementVariant("lossy-prefix", false, false, true){

        public void addTestProperties(TestCaseEx test) {
            test.addTestProperty("method", "QName");
        }

        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            OMElement orgElement = factory.createOMElement(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            orgElement.serialize((OutputStream)baos);
            ByteArrayDataSource ds = new ByteArrayDataSource(baos.toByteArray(), "UTF-8");
            ds.setProperty("lossyPrefix", (Object)Boolean.TRUE);
            return factory.createOMElement((OMDataSource)ds, new QName(qname.getNamespaceURI(), qname.getLocalPart()));
        }
    }, new OMSourcedElementVariant("lossy-prefix", false, false, true){

        public void addTestProperties(TestCaseEx test) {
            test.addTestProperty("method", "OMNamespace");
        }

        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            OMElement orgElement = factory.createOMElement(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            orgElement.serialize((OutputStream)baos);
            ByteArrayDataSource ds = new ByteArrayDataSource(baos.toByteArray(), "UTF-8");
            ds.setProperty("lossyPrefix", (Object)Boolean.TRUE);
            OMNamespace ns = qname.getNamespaceURI().length() == 0 ? null : factory.createOMNamespace(qname.getNamespaceURI(), "");
            return factory.createOMElement((OMDataSource)ds, qname.getLocalPart(), ns);
        }
    }, new OMSourcedElementVariant("unknown-prefix", false, false, true){

        public OMSourcedElement createOMSourcedElement(OMFactory factory, QName qname) throws Exception {
            OMElement orgElement = factory.createOMElement(qname.getLocalPart(), qname.getNamespaceURI(), qname.getPrefix());
            return factory.createOMElement((OMDataSource)new TestDataSource(orgElement.toString()), qname.getLocalPart(), factory.createOMNamespace(qname.getNamespaceURI(), null));
        }
    }};
    private final String name;
    private final boolean localNameRequiresExpansion;
    private final boolean namespaceURIRequiresExpansion;
    private final boolean prefixRequiresExpansion;

    public OMSourcedElementVariant(String name, boolean localNameRequiresExpansion, boolean namespaceURIRequiresExpansion, boolean prefixRequiresExpansion) {
        this.name = name;
        this.localNameRequiresExpansion = localNameRequiresExpansion;
        this.namespaceURIRequiresExpansion = namespaceURIRequiresExpansion;
        this.prefixRequiresExpansion = prefixRequiresExpansion;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocalNameRequiresExpansion() {
        return this.localNameRequiresExpansion;
    }

    public boolean isNamespaceURIRequiresExpansion() {
        return this.namespaceURIRequiresExpansion;
    }

    public boolean isPrefixRequiresExpansion(QName qname) {
        return this.prefixRequiresExpansion && (this.namespaceURIRequiresExpansion || qname.getNamespaceURI().length() != 0);
    }

    public void addTestProperties(TestCaseEx test) {
    }

    public abstract OMSourcedElement createOMSourcedElement(OMFactory var1, QName var2) throws Exception;
}

