/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.CharArrayDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestCharArrayDS
extends AxiomTestCase {
    public TestCharArrayDS(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        String localName = "myPayload";
        String encoding = "utf-8";
        String payload1 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        OMNamespace ns = factory.createOMNamespace("urn://test", "tns");
        CharArrayDataSource cads = new CharArrayDataSource(payload1.toCharArray());
        OMElement parent = factory.createOMElement("root", null);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)cads, localName, ns);
        parent.addChild((OMNode)omse);
        OMNode firstChild = parent.getFirstOMChild();
        TestCharArrayDS.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof OMSourcedElement));
        OMSourcedElement child = (OMSourcedElement)firstChild;
        TestCharArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestCharArrayDS.assertTrue((String)"OMSourcedElement should be backed by a ByteArrayDataSource", (boolean)(child.getDataSource() instanceof CharArrayDataSource));
        XMLStreamReader reader = child.getXMLStreamReader();
        reader.next();
        TestCharArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        parent.serialize((OutputStream)baos);
        String output = baos.toString(encoding);
        TestCharArrayDS.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        TestCharArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        OMDataSourceExt ds = (OMDataSourceExt)child.getDataSource();
        char[] chars = (char[])ds.getObject();
        String payload = new String(chars);
        TestCharArrayDS.assertTrue((String)"The obtained chars did not match the payload", (boolean)payload1.equals(payload));
        ds.close();
        TestCharArrayDS.assertTrue((String)"Close should free the resource", (ds.getObject() == null ? 1 : 0) != 0);
    }
}

