/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.serialize.StreamingOMSerializer;
import org.apache.axiom.om.util.StAXUtils;

class TestDataSource
implements OMDataSource {
    private final ByteArrayInputStream data;

    TestDataSource(String data) {
        this.data = new ByteArrayInputStream(data.getBytes());
        this.data.mark(0);
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        try {
            output.write(this.getBytes());
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(Writer writer, OMOutputFormat format) throws XMLStreamException {
        try {
            writer.write(this.getString());
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        StreamingOMSerializer serializer = new StreamingOMSerializer();
        serializer.serialize(this.getReader(), xmlWriter);
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        return StAXUtils.createXMLStreamReader((Reader)new StringReader(this.getString()));
    }

    private byte[] getBytes() throws XMLStreamException {
        try {
            byte[] rc = new byte[this.data.available()];
            this.data.read(rc);
            return rc;
        }
        catch (IOException io) {
            throw new XMLStreamException(io);
        }
    }

    private String getString() throws XMLStreamException {
        String text = new String(this.getBytes());
        return text;
    }
}

