/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.ts.om.sourcedelement.OMSourcedElementTest;

public class TestExpand
extends OMSourcedElementTest {
    public TestExpand(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        this.element.getAllDeclaredNamespaces();
        TestExpand.assertEquals((String)"Expanded namespace count error", (int)1, (int)this.countItems(this.element.getAllDeclaredNamespaces()));
        TestExpand.assertEquals((String)"Expanded attribute count error", (int)1, (int)this.countItems(this.element.getAllAttributes()));
        TestExpand.assertEquals((String)"Expanded attribute value error", (String)"1", (String)this.element.getAttributeValue(new QName("books")));
        OMElement child = this.element.getFirstElement();
        TestExpand.assertEquals((String)"Child element name", (String)"type", (String)child.getLocalName());
        TestExpand.assertEquals((String)"Child element namespace", (String)"http://www.sosnoski.com/uwjws/library", (String)child.getNamespace().getNamespaceURI());
        OMNode next = child.getNextOMSibling();
        TestExpand.assertTrue((String)"Expected child element", (boolean)(next instanceof OMElement));
        next = next.getNextOMSibling();
        TestExpand.assertTrue((String)"Expected child element", (boolean)(next instanceof OMElement));
        child = (OMElement)next;
        TestExpand.assertEquals((String)"Child element name", (String)"book", (String)child.getLocalName());
        TestExpand.assertEquals((String)"Child element namespace", (String)"http://www.sosnoski.com/uwjws/library", (String)child.getNamespace().getNamespaceURI());
        TestExpand.assertEquals((String)"Attribute value error", (String)"xml", (String)child.getAttributeValue(new QName("type")));
    }

    private int countItems(Iterator iter) {
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            iter.next();
        }
        return count;
    }
}

