/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.InputStreamDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestInputStreamDS
extends AxiomTestCase {
    public TestInputStreamDS(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        String localName = "myPayload";
        String encoding = "utf-8";
        String payload1 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        OMNamespace ns = factory.createOMNamespace("urn://test", "tns");
        ByteArrayInputStream bais1 = new ByteArrayInputStream(payload1.getBytes(encoding));
        InputStreamDataSource isds1 = new InputStreamDataSource((InputStream)bais1, encoding);
        OMElement parent = factory.createOMElement("root", null);
        OMSourcedElement omse = factory.createOMElement((OMDataSource)isds1, localName, ns);
        parent.addChild((OMNode)omse);
        OMNode firstChild = parent.getFirstOMChild();
        TestInputStreamDS.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof OMSourcedElement));
        OMSourcedElement child = (OMSourcedElement)firstChild;
        TestInputStreamDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestInputStreamDS.assertTrue((String)"OMSourcedElement should be backed by a InputStreamDataSource", (boolean)(child.getDataSource() instanceof InputStreamDataSource));
        XMLStreamReader reader = child.getXMLStreamReader();
        reader.next();
        TestInputStreamDS.assertTrue((String)"OMSourcedElement is not expanded.  This is unexpected", (boolean)child.isExpanded());
        child.detach();
        isds1 = new InputStreamDataSource((InputStream)new ByteArrayInputStream(payload1.getBytes(encoding)), encoding);
        omse = factory.createOMElement((OMDataSource)isds1, localName, ns);
        parent.addChild((OMNode)omse);
        firstChild = parent.getFirstOMChild();
        child = (OMSourcedElement)firstChild;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        parent.serialize((OutputStream)baos);
        String output = baos.toString(encoding);
        TestInputStreamDS.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        TestInputStreamDS.assertTrue((String)"OMSourcedElement is not expanded.  This is unexpected", (boolean)child.isExpanded());
        child.detach();
        isds1 = new InputStreamDataSource((InputStream)new ByteArrayInputStream(payload1.getBytes(encoding)), encoding);
        omse = factory.createOMElement((OMDataSource)isds1, localName, ns);
        parent.addChild((OMNode)omse);
        firstChild = parent.getFirstOMChild();
        child = (OMSourcedElement)firstChild;
        OMDataSourceExt ds = (OMDataSourceExt)child.getDataSource();
        byte[] bytes = ds.getXMLBytes(encoding);
        String payload = new String(bytes, encoding);
        TestInputStreamDS.assertTrue((String)"The obtained bytes did not match the payload", (boolean)payload1.equals(payload));
    }
}

