/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement.push;

import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestWriteNamespace
extends AxiomTestCase {
    private final String prefix;
    private final String namespaceURI;

    public TestWriteNamespace(OMMetaFactory metaFactory, String prefix, String namespaceURI) {
        super(metaFactory);
        this.prefix = prefix;
        this.namespaceURI = namespaceURI;
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMSourcedElement element = factory.createOMElement((OMDataSource)new AbstractPushOMDataSource(){

            public void serialize(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement("_p_", "root", "urn:__test__");
                writer.writeNamespace("_p_", "urn:test");
                writer.writeNamespace(TestWriteNamespace.this.prefix, TestWriteNamespace.this.namespaceURI);
                writer.writeEndElement();
            }

            public boolean isDestructiveWrite() {
                return false;
            }
        });
        OMNamespace decl = null;
        Iterator it = element.getAllDeclaredNamespaces();
        while (it.hasNext()) {
            OMNamespace ns = (OMNamespace)it.next();
            if (ns.getPrefix().equals("_p_")) continue;
            if (decl != null) {
                TestWriteNamespace.fail((String)"Found unexpected namespace declaration");
                continue;
            }
            decl = ns;
        }
        TestWriteNamespace.assertNotNull(decl);
        TestWriteNamespace.assertEquals((String)this.prefix, (String)decl.getPrefix());
        TestWriteNamespace.assertEquals((String)this.namespaceURI, (String)decl.getNamespaceURI());
    }
}

