/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.omdom.document;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axiom.ts.AxiomTestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestImportNode
extends AxiomTestCase {
    public TestImportNode(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(AbstractTestCase.getTestResource((String)"sigEncr.xml"));
        Document doc2 = ((DOMMetaFactory)this.metaFactory).newDocumentBuilderFactory().newDocumentBuilder().newDocument();
        Node n = doc2.importNode(doc.getDocumentElement(), true);
        TestImportNode.compare(doc.getDocumentElement(), (OMElement)n);
    }

    private static void compare(Element ele, OMElement omele) throws Exception {
        if (ele == null && omele == null) {
            return;
        }
        if (ele != null && omele != null) {
            TestImportNode.assertEquals((String)"Element name not correct", (String)ele.getLocalName(), (String)omele.getLocalName());
            if (omele.getNamespace() != null) {
                TestImportNode.assertEquals((String)"Namespace URI not correct", (String)ele.getNamespaceURI(), (String)omele.getNamespace().getNamespaceURI());
            }
            NamedNodeMap map = ele.getAttributes();
            Iterator attIterator = omele.getAllAttributes();
            while (attIterator.hasNext()) {
                OMAttribute omattribute = (OMAttribute)attIterator.next();
                Node node = map.getNamedItemNS(omattribute.getNamespaceURI(), omattribute.getLocalName());
                if (node.getNodeType() == 2) {
                    Attr attr = (Attr)node;
                    TestImportNode.assertEquals((String)attr.getValue(), (String)omattribute.getAttributeValue());
                    continue;
                }
                throw new OMException("return type is not a Attribute");
            }
            Iterator it = omele.getChildren();
            NodeList list = ele.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (node.getNodeType() != 1) continue;
                TestImportNode.assertTrue((boolean)it.hasNext());
                OMNode tempOmNode = (OMNode)it.next();
                while (tempOmNode.getType() != 1) {
                    TestImportNode.assertTrue((boolean)it.hasNext());
                    tempOmNode = (OMNode)it.next();
                }
                TestImportNode.compare((Element)node, (OMElement)tempOmNode);
            }
        } else {
            throw new Exception("One is null");
        }
    }
}

