/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAP11Version;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPVersion;

public abstract class SOAPSpec {
    public static final SOAPSpec SOAP11 = new SOAPSpec((SOAPVersion)SOAP11Version.getSingleton()){

        public String getName() {
            return "soap11";
        }

        public SOAPFactory getFactory(OMMetaFactory metaFactory) {
            return metaFactory.getSOAP11Factory();
        }

        public SOAPFactory getAltFactory(OMMetaFactory metaFactory) {
            return metaFactory.getSOAP12Factory();
        }

        public String getEnvelopeNamespaceURI() {
            return "http://schemas.xmlsoap.org/soap/envelope/";
        }
    };
    public static final SOAPSpec SOAP12 = new SOAPSpec((SOAPVersion)SOAP12Version.getSingleton()){

        public String getName() {
            return "soap12";
        }

        public SOAPFactory getFactory(OMMetaFactory metaFactory) {
            return metaFactory.getSOAP12Factory();
        }

        public SOAPFactory getAltFactory(OMMetaFactory metaFactory) {
            return metaFactory.getSOAP11Factory();
        }

        public String getEnvelopeNamespaceURI() {
            return "http://www.w3.org/2003/05/soap-envelope";
        }
    };
    private final SOAPVersion version;

    public SOAPSpec(SOAPVersion version) {
        this.version = version;
    }

    public abstract String getName();

    public abstract SOAPFactory getFactory(OMMetaFactory var1);

    public abstract SOAPFactory getAltFactory(OMMetaFactory var1);

    public abstract String getEnvelopeNamespaceURI();

    public QName getFaultCodeQName() {
        return this.version.getFaultCodeQName();
    }

    public QName getFaultReasonQName() {
        return this.version.getFaultReasonQName();
    }

    public QName getFaultRoleQName() {
        return this.version.getFaultRoleQName();
    }

    public QName getFaultDetailQName() {
        return this.version.getFaultDetailQName();
    }

    public String getNextRoleURI() {
        return this.version.getNextRoleURI();
    }

    public SOAPVersion getVersion() {
        return this.version;
    }
}

