/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.testutils.suite.TestSuiteBuilder;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.body.TestAddFault1;
import org.apache.axiom.ts.soap.body.TestAddFault2;
import org.apache.axiom.ts.soap.body.TestGetFault;
import org.apache.axiom.ts.soap.body.TestGetFaultFakeFault;
import org.apache.axiom.ts.soap.body.TestGetFaultNoFault;
import org.apache.axiom.ts.soap.body.TestGetFaultWithParser;
import org.apache.axiom.ts.soap.body.TestGetFaultWithParserNoFault;
import org.apache.axiom.ts.soap.body.TestGetFirstElementLocalNameEmptyBody;
import org.apache.axiom.ts.soap.body.TestGetFirstElementLocalNameWithParser;
import org.apache.axiom.ts.soap.body.TestGetFirstElementNSEmptyBody;
import org.apache.axiom.ts.soap.body.TestGetFirstElementNSWithParser;
import org.apache.axiom.ts.soap.body.TestHasFaultAfterReplace;
import org.apache.axiom.ts.soap.body.TestHasFaultFakeFault;
import org.apache.axiom.ts.soap.body.TestHasFaultNoFault;
import org.apache.axiom.ts.soap.body.TestHasFaultWithOMSEUnknownName;
import org.apache.axiom.ts.soap.body.TestHasFaultWithParserNoFault;
import org.apache.axiom.ts.soap.builder.BadInputTest;
import org.apache.axiom.ts.soap.builder.MessageTest;
import org.apache.axiom.ts.soap.builder.TestCommentInEpilog;
import org.apache.axiom.ts.soap.builder.TestCommentInProlog;
import org.apache.axiom.ts.soap.builder.TestDTD;
import org.apache.axiom.ts.soap.builder.TestRegisterCustomBuilderForPayloadAfterSOAPFaultCheck;
import org.apache.axiom.ts.soap.envelope.TestAddHeaderToIncompleteEnvelope;
import org.apache.axiom.ts.soap.envelope.TestBodyHeaderOrder;
import org.apache.axiom.ts.soap.envelope.TestCloneWithSourcedElement1;
import org.apache.axiom.ts.soap.envelope.TestCloneWithSourcedElement2;
import org.apache.axiom.ts.soap.envelope.TestDetach;
import org.apache.axiom.ts.soap.envelope.TestGetBody;
import org.apache.axiom.ts.soap.envelope.TestGetBodyOnEmptyEnvelope;
import org.apache.axiom.ts.soap.envelope.TestGetBodyOnEnvelopeWithHeaderOnly;
import org.apache.axiom.ts.soap.envelope.TestGetBodyWithParser;
import org.apache.axiom.ts.soap.envelope.TestGetHeader;
import org.apache.axiom.ts.soap.envelope.TestGetHeaderWithParser;
import org.apache.axiom.ts.soap.envelope.TestGetSOAPBodyFirstElementLocalNameAndNS;
import org.apache.axiom.ts.soap.envelope.TestGetSOAPBodyFirstElementLocalNameAndNSWithParser;
import org.apache.axiom.ts.soap.envelope.TestGetXMLStreamReaderWithoutCachingWithPartiallyBuiltHeaderBlock;
import org.apache.axiom.ts.soap.envelope.TestHasFault;
import org.apache.axiom.ts.soap.envelope.TestHasFaultWithParser;
import org.apache.axiom.ts.soap.envelope.TestHasFaultWithParserOptimized;
import org.apache.axiom.ts.soap.envelope.TestSerializeAndConsumeWithOMSEInBody;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPEnvelope;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPEnvelopeWithCustomPrefix;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPFault;
import org.apache.axiom.ts.soap.factory.TestCreateSOAPFaultDetail;
import org.apache.axiom.ts.soap.factory.TestFactoryIsSingleton;
import org.apache.axiom.ts.soap.factory.TestGetDefaultEnvelope;
import org.apache.axiom.ts.soap.factory.TestGetDefaultFaultEnvelope;
import org.apache.axiom.ts.soap.factory.TestGetMetaFactory;
import org.apache.axiom.ts.soap.factory.TestGetNamespace;
import org.apache.axiom.ts.soap.fault.TestGetCode;
import org.apache.axiom.ts.soap.fault.TestGetCodeWithParser;
import org.apache.axiom.ts.soap.fault.TestGetDetail;
import org.apache.axiom.ts.soap.fault.TestGetDetailWithParser;
import org.apache.axiom.ts.soap.fault.TestGetException;
import org.apache.axiom.ts.soap.fault.TestGetReason;
import org.apache.axiom.ts.soap.fault.TestGetReasonWithParser;
import org.apache.axiom.ts.soap.fault.TestGetRoleWithParser;
import org.apache.axiom.ts.soap.fault.TestSetCode;
import org.apache.axiom.ts.soap.fault.TestSetDetail;
import org.apache.axiom.ts.soap.fault.TestSetException;
import org.apache.axiom.ts.soap.fault.TestSetReason;
import org.apache.axiom.ts.soap.fault.TestWrongParent1;
import org.apache.axiom.ts.soap.faultcode.TestGetValueAsQName;
import org.apache.axiom.ts.soap.faultdetail.TestAddDetailEntry;
import org.apache.axiom.ts.soap.faultdetail.TestDetailEntriesUsingDefaultNamespaceWithParser;
import org.apache.axiom.ts.soap.faultdetail.TestGetAllDetailEntries;
import org.apache.axiom.ts.soap.faultdetail.TestGetAllDetailEntriesWithParser;
import org.apache.axiom.ts.soap.faultdetail.TestSerialization;
import org.apache.axiom.ts.soap.faultdetail.TestWSCommons202;
import org.apache.axiom.ts.soap.faulttext.TestSetLang;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlock;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlockWithoutNamespace1;
import org.apache.axiom.ts.soap.header.TestAddHeaderBlockWithoutNamespace2;
import org.apache.axiom.ts.soap.header.TestDiscardIncomplete;
import org.apache.axiom.ts.soap.header.TestDiscardPartiallyBuilt;
import org.apache.axiom.ts.soap.header.TestExamineAllHeaderBlocks;
import org.apache.axiom.ts.soap.header.TestExamineHeaderBlocks;
import org.apache.axiom.ts.soap.header.TestExtractAllHeaderBlocks;
import org.apache.axiom.ts.soap.header.TestGetHeaderBlocksWithNSURI;
import org.apache.axiom.ts.soap.header.TestGetHeadersToProcessWithNamespace;
import org.apache.axiom.ts.soap.headerblock.TestByteArrayDS;
import org.apache.axiom.ts.soap.headerblock.TestGetMustUnderstand;
import org.apache.axiom.ts.soap.headerblock.TestGetRole;
import org.apache.axiom.ts.soap.headerblock.TestGetVersion;
import org.apache.axiom.ts.soap.headerblock.TestSetMustUnderstandBoolean;
import org.apache.axiom.ts.soap.headerblock.TestSetMustUnderstandString01;
import org.apache.axiom.ts.soap.headerblock.TestSetMustUnderstandWithInvalidValue;
import org.apache.axiom.ts.soap.headerblock.TestSetRole;
import org.apache.axiom.ts.soap.headerblock.TestWrongParent2;
import org.apache.axiom.ts.soap.headerblock.TestWrongParent3;
import org.apache.axiom.ts.soap.message.TestClone;
import org.apache.axiom.ts.soap.message.TestCloneIncomplete;
import org.apache.axiom.ts.soap.message.TestGetCharsetEncodingWithParser;
import org.apache.axiom.ts.soap.message.TestGetOMFactoryWithParser;
import org.apache.axiom.ts.soap.xpath.TestXPathAppliedToSOAPEnvelope;
import org.apache.axiom.ts.soap11.builder.TestBuilder;
import org.apache.axiom.ts.soap11.fault.TestGetNode;
import org.apache.axiom.ts.soap11.faultcode.TestGetValue;
import org.apache.axiom.ts.soap11.faultcode.TestSetValueFromQName;
import org.apache.axiom.ts.soap11.faultreason.TestAddSOAPText;
import org.apache.axiom.ts.soap11.faultreason.TestGetFirstSOAPText;
import org.apache.axiom.ts.soap11.faultreason.TestGetTextWithCDATA;
import org.apache.axiom.ts.soap11.header.TestExamineHeaderBlocksWithParser;
import org.apache.axiom.ts.soap11.header.TestExamineMustUnderstandHeaderBlocksWithParser;
import org.apache.axiom.ts.soap11.header.TestGetHeaderBlocksWithNSURIWithParser;
import org.apache.axiom.ts.soap11.header.TestGetHeadersToProcessWithParser;
import org.apache.axiom.ts.soap12.envelope.TestAddElementAfterBody;
import org.apache.axiom.ts.soap12.envelope.TestBuildWithAttachments;
import org.apache.axiom.ts.soap12.envelope.TestMTOMForwardStreaming;
import org.apache.axiom.ts.soap12.factory.TestCreateSOAPFaultSubCode;
import org.apache.axiom.ts.soap12.fault.TestGetNodeWithParser;
import org.apache.axiom.ts.soap12.fault.TestMoreChildrenAddition;
import org.apache.axiom.ts.soap12.fault.TestSetNode;
import org.apache.axiom.ts.soap12.faultcode.TestGetSubCodeWithParser;
import org.apache.axiom.ts.soap12.faultcode.TestGetValueWithParser;
import org.apache.axiom.ts.soap12.faultcode.TestSetValueFromQNameWithExistingValue;
import org.apache.axiom.ts.soap12.faultreason.TestAddSOAPTextWithSOAPVersionMismatch;
import org.apache.axiom.ts.soap12.faultreason.TestGetFirstSOAPTextWithParser;
import org.apache.axiom.ts.soap12.faultsubcode.TestGetSubCodeNestedWithParser;
import org.apache.axiom.ts.soap12.faultsubcode.TestGetValueAsQNameWithParser;
import org.apache.axiom.ts.soap12.faultsubcode.TestGetValueNestedWithParser;
import org.apache.axiom.ts.soap12.faulttext.TestGetLangWithParser;
import org.apache.axiom.ts.soap12.header.TestExamineAllHeaderBlocksWithParser;
import org.apache.axiom.ts.soap12.header.TestExamineMustUnderstandHeaderBlocks;

public class SOAPTestSuiteBuilder
extends TestSuiteBuilder {
    private static final String[] badSOAPFiles = new String[]{"wrongSoapNs.xml", "notnamespaceQualified.xml", "soap11/twoheaders.xml", "soap11/twoBodymessage.xml", "soap11/envelopeMissing.xml", "soap11/haederBodyWrongOrder.xml", "soap11/invalid-faultcode.xml", "soap11/invalid-faultstring.xml", "soap11/invalid-faultactor.xml", "soap11/processing-instruction.xml", "soap11/entity-reference.xml", "soap12/header-bad-case.xml", "soap12/header-no-namespace.xml", "soap12/processing-instruction.xml", "soap12/entity-reference.xml", "soap12/additional-element-after-body.xml"};
    private static final String[] goodSOAPFiles = new String[]{"soap/soap11/whitespacedMessage.xml", "soap/soap11/minimalMessage.xml", "soap/soap11/reallyReallyBigMessage.xml", "soap/soap11/emtyBodymessage.xml", "soap/soap11/soapfault.xml", "soap/soap11/bodyNotQualified.xml", "soap/soap11/faultstring-with-comment.xml", "soap/soap11/additional-element-after-body.xml"};
    private static final QName[] generalQNames = new QName[]{new QName("root"), new QName("urn:test", "root", "p"), new QName("urn:test", "root")};
    private static final QName[] noFaultQNames = new QName[]{new QName("root"), new QName("urn:test", "root", "p"), new QName("urn:test", "root"), new QName("Fault"), new QName("urn:test", "Fault", "p"), new QName("http://schemas.xmlsoap.org/soap/envelope/", "NoFault", "soapenv"), new QName("http://www.w3.org/2003/05/soap-envelope", "NoFault", "soapenv")};
    private final OMMetaFactory metaFactory;
    private final boolean supportsOMSourcedElement;
    private final boolean supportsBodyElementNameOptimization;

    public SOAPTestSuiteBuilder(OMMetaFactory metaFactory, boolean supportsOMSourcedElement, boolean supportsBodyElementNameOptimization) {
        this.metaFactory = metaFactory;
        this.supportsOMSourcedElement = supportsOMSourcedElement;
        this.supportsBodyElementNameOptimization = supportsBodyElementNameOptimization;
    }

    private void addTests(SOAPSpec spec) {
        QName qname;
        int i;
        this.addTest(new TestAddFault1(this.metaFactory, spec));
        this.addTest(new TestAddFault2(this.metaFactory, spec));
        this.addTest(new TestGetFault(this.metaFactory, spec));
        this.addTest(new TestGetFaultFakeFault(this.metaFactory, spec));
        this.addTest(new TestGetFaultWithParser(this.metaFactory, spec));
        for (i = 0; i < generalQNames.length; ++i) {
            qname = generalQNames[i];
            this.addTest(new TestGetFirstElementLocalNameWithParser(this.metaFactory, spec, qname, this.supportsBodyElementNameOptimization));
            this.addTest(new TestGetFirstElementNSWithParser(this.metaFactory, spec, qname, this.supportsBodyElementNameOptimization));
        }
        for (i = 0; i < noFaultQNames.length; ++i) {
            qname = noFaultQNames[i];
            this.addTest(new TestGetFaultNoFault(this.metaFactory, spec, qname));
            this.addTest(new TestGetFaultWithParserNoFault(this.metaFactory, spec, qname));
            this.addTest(new TestHasFaultNoFault(this.metaFactory, spec, qname));
            this.addTest(new TestHasFaultWithParserNoFault(this.metaFactory, spec, qname, this.supportsBodyElementNameOptimization));
        }
        this.addTest(new TestGetFirstElementLocalNameEmptyBody(this.metaFactory, spec));
        this.addTest(new TestGetFirstElementNSEmptyBody(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.body.TestHasFault(this.metaFactory, spec));
        this.addTest(new TestHasFaultAfterReplace(this.metaFactory, spec));
        this.addTest(new TestHasFaultFakeFault(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestHasFaultWithOMSEUnknownName(this.metaFactory, spec));
        }
        this.addTest(new org.apache.axiom.ts.soap.body.TestHasFaultWithParser(this.metaFactory, spec));
        this.addTest(new TestCommentInEpilog(this.metaFactory, spec));
        this.addTest(new TestCommentInProlog(this.metaFactory, spec));
        this.addTest(new TestDTD(this.metaFactory, spec));
        if (this.supportsBodyElementNameOptimization) {
            this.addTest(new TestRegisterCustomBuilderForPayloadAfterSOAPFaultCheck(this.metaFactory, spec));
        }
        this.addTest(new TestAddHeaderToIncompleteEnvelope(this.metaFactory, spec));
        this.addTest(new TestBodyHeaderOrder(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestCloneWithSourcedElement1(this.metaFactory, spec));
            this.addTest(new TestCloneWithSourcedElement2(this.metaFactory, spec));
        }
        this.addTest(new TestDetach(this.metaFactory, spec));
        this.addTest(new TestGetBody(this.metaFactory, spec));
        this.addTest(new TestGetBodyOnEmptyEnvelope(this.metaFactory, spec));
        this.addTest(new TestGetBodyOnEnvelopeWithHeaderOnly(this.metaFactory, spec));
        this.addTest(new TestGetBodyWithParser(this.metaFactory, spec));
        this.addTest(new TestGetHeader(this.metaFactory, spec));
        this.addTest(new TestGetHeaderWithParser(this.metaFactory, spec));
        for (i = 0; i < generalQNames.length; ++i) {
            qname = generalQNames[i];
            this.addTest(new TestGetSOAPBodyFirstElementLocalNameAndNS(this.metaFactory, spec, qname));
            this.addTest(new TestGetSOAPBodyFirstElementLocalNameAndNSWithParser(this.metaFactory, spec, qname));
        }
        this.addTest(new TestGetXMLStreamReaderWithoutCachingWithPartiallyBuiltHeaderBlock(this.metaFactory, spec));
        this.addTest(new TestHasFault(this.metaFactory, spec));
        this.addTest(new TestHasFaultWithParser(this.metaFactory, spec));
        this.addTest(new TestHasFaultWithParserOptimized(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestSerializeAndConsumeWithOMSEInBody(this.metaFactory, spec));
        }
        this.addTest(new TestCreateSOAPEnvelope(this.metaFactory, spec));
        this.addTest(new TestCreateSOAPEnvelopeWithCustomPrefix(this.metaFactory, spec));
        this.addTest(new TestCreateSOAPFault(this.metaFactory, spec));
        this.addTest(new TestCreateSOAPFaultDetail(this.metaFactory, spec));
        this.addTest(new TestFactoryIsSingleton(this.metaFactory, spec));
        this.addTest(new TestGetDefaultEnvelope(this.metaFactory, spec));
        this.addTest(new TestGetDefaultFaultEnvelope(this.metaFactory, spec));
        this.addTest(new TestGetMetaFactory(this.metaFactory, spec));
        this.addTest(new TestGetNamespace(this.metaFactory, spec));
        this.addTest(new TestGetCode(this.metaFactory, spec));
        this.addTest(new TestGetCodeWithParser(this.metaFactory, spec));
        this.addTest(new TestGetDetail(this.metaFactory, spec));
        this.addTest(new TestGetDetailWithParser(this.metaFactory, spec));
        this.addTest(new TestGetException(this.metaFactory, spec));
        this.addTest(new TestGetReason(this.metaFactory, spec));
        this.addTest(new TestGetReasonWithParser(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.fault.TestGetRole(this.metaFactory, spec));
        this.addTest(new TestGetRoleWithParser(this.metaFactory, spec));
        this.addTest(new TestSetCode(this.metaFactory, spec));
        this.addTest(new TestSetDetail(this.metaFactory, spec));
        this.addTest(new TestSetException(this.metaFactory, spec));
        this.addTest(new TestSetReason(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.fault.TestSetRole(this.metaFactory, spec));
        this.addTest(new TestWrongParent1(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.fault.TestWrongParent2(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.fault.TestWrongParent3(this.metaFactory, spec));
        this.addTest(new TestGetValueAsQName(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.faultcode.TestGetValueAsQNameWithParser(this.metaFactory, spec));
        this.addTest(new TestAddDetailEntry(this.metaFactory, spec));
        this.addTest(new TestDetailEntriesUsingDefaultNamespaceWithParser(this.metaFactory, spec));
        this.addTest(new TestGetAllDetailEntries(this.metaFactory, spec));
        this.addTest(new TestGetAllDetailEntriesWithParser(this.metaFactory, spec));
        this.addTest(new TestSerialization(this.metaFactory, spec));
        this.addTest(new TestWSCommons202(this.metaFactory, spec));
        this.addTest(new TestSetLang(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlock(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlockWithoutNamespace1(this.metaFactory, spec));
        this.addTest(new TestAddHeaderBlockWithoutNamespace2(this.metaFactory, spec));
        this.addTest(new TestDiscardIncomplete(this.metaFactory, spec));
        this.addTest(new TestDiscardPartiallyBuilt(this.metaFactory, spec));
        this.addTest(new TestExamineAllHeaderBlocks(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.header.TestExamineAllHeaderBlocksWithParser(this.metaFactory, spec));
        this.addTest(new TestExamineHeaderBlocks(this.metaFactory, spec));
        this.addTest(new TestExtractAllHeaderBlocks(this.metaFactory, spec));
        this.addTest(new TestGetHeaderBlocksWithNSURI(this.metaFactory, spec));
        this.addTest(new TestGetHeadersToProcessWithNamespace(this.metaFactory, spec));
        if (this.supportsOMSourcedElement) {
            this.addTest(new TestByteArrayDS(this.metaFactory, spec));
        }
        this.addTest(new TestGetMustUnderstand(this.metaFactory, spec));
        this.addTest(new TestGetRole(this.metaFactory, spec));
        this.addTest(new TestGetVersion(this.metaFactory, spec));
        this.addTest(new TestSetMustUnderstandBoolean(this.metaFactory, spec, true, spec == SOAPSpec.SOAP11 ? "1" : "true"));
        this.addTest(new TestSetMustUnderstandBoolean(this.metaFactory, spec, false, spec == SOAPSpec.SOAP11 ? "0" : "false"));
        this.addTest(new TestSetMustUnderstandString01(this.metaFactory, spec));
        this.addTest(new TestSetMustUnderstandWithInvalidValue(this.metaFactory, spec));
        this.addTest(new TestSetRole(this.metaFactory, spec));
        this.addTest(new org.apache.axiom.ts.soap.headerblock.TestWrongParent1(this.metaFactory, spec));
        this.addTest(new TestWrongParent2(this.metaFactory, spec));
        this.addTest(new TestWrongParent3(this.metaFactory, spec));
        this.addTest(new TestClone(this.metaFactory, spec, true));
        this.addTest(new TestClone(this.metaFactory, spec, false));
        this.addTest(new TestCloneIncomplete(this.metaFactory, spec, true));
        this.addTest(new TestCloneIncomplete(this.metaFactory, spec, false));
        this.addTest(new TestGetCharsetEncodingWithParser(this.metaFactory, spec));
        this.addTest(new TestGetOMFactoryWithParser(this.metaFactory, spec));
        this.addTest(new TestXPathAppliedToSOAPEnvelope(this.metaFactory, spec, true));
        this.addTest(new TestXPathAppliedToSOAPEnvelope(this.metaFactory, spec, false));
    }

    protected void addTests() {
        int i;
        this.addTests(SOAPSpec.SOAP11);
        this.addTests(SOAPSpec.SOAP12);
        for (i = 0; i < badSOAPFiles.length; ++i) {
            this.addTest(new BadInputTest(this.metaFactory, badSOAPFiles[i]));
        }
        for (i = 0; i < goodSOAPFiles.length; ++i) {
            this.addTest(new MessageTest(this.metaFactory, goodSOAPFiles[i]));
        }
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "sample1.xml"));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "soapmessage.xml"));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "soapmessage1.xml"));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "whitespacedMessage.xml"));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "minimalMessage.xml"));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "reallyReallyBigMessage.xml"));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "emtyBodymessage.xml"));
        this.addTest(new org.apache.axiom.ts.soap.envelope.TestClone(this.metaFactory, SOAPSpec.SOAP11, "soap11fault.xml"));
        this.addTest(new TestBuilder(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.envelope.TestAddElementAfterBody(this.metaFactory));
        this.addTest(new TestGetNode(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.fault.TestSetNode(this.metaFactory));
        this.addTest(new TestGetValue(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.faultcode.TestGetValueWithParser(this.metaFactory));
        this.addTest(new TestSetValueFromQName(this.metaFactory));
        this.addTest(new TestAddSOAPText(this.metaFactory));
        this.addTest(new TestGetFirstSOAPText(this.metaFactory));
        this.addTest(new TestGetTextWithCDATA(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap11.header.TestExamineAllHeaderBlocksWithParser(this.metaFactory));
        this.addTest(new TestExamineHeaderBlocksWithParser(this.metaFactory));
        this.addTest(new TestExamineMustUnderstandHeaderBlocksWithParser(this.metaFactory));
        this.addTest(new TestGetHeaderBlocksWithNSURIWithParser(this.metaFactory));
        this.addTest(new TestGetHeadersToProcessWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.builder.TestBuilder(this.metaFactory));
        this.addTest(new TestAddElementAfterBody(this.metaFactory));
        this.addTest(new TestBuildWithAttachments(this.metaFactory));
        this.addTest(new TestMTOMForwardStreaming(this.metaFactory, true));
        this.addTest(new TestMTOMForwardStreaming(this.metaFactory, false));
        this.addTest(new TestCreateSOAPFaultSubCode(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.fault.TestGetNode(this.metaFactory));
        this.addTest(new TestGetNodeWithParser(this.metaFactory));
        this.addTest(new TestMoreChildrenAddition(this.metaFactory));
        this.addTest(new TestSetNode(this.metaFactory));
        this.addTest(new TestGetSubCodeWithParser(this.metaFactory));
        this.addTest(new TestGetValueWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultcode.TestSetValueFromQName(this.metaFactory));
        this.addTest(new TestSetValueFromQNameWithExistingValue(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultreason.TestAddSOAPText(this.metaFactory));
        this.addTest(new TestAddSOAPTextWithSOAPVersionMismatch(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultreason.TestGetFirstSOAPText(this.metaFactory));
        this.addTest(new TestGetFirstSOAPTextWithParser(this.metaFactory));
        this.addTest(new TestGetSubCodeNestedWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultsubcode.TestGetSubCodeWithParser(this.metaFactory));
        this.addTest(new TestGetValueNestedWithParser(this.metaFactory));
        this.addTest(new TestGetValueAsQNameWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.faultsubcode.TestGetValueWithParser(this.metaFactory));
        this.addTest(new TestGetLangWithParser(this.metaFactory));
        this.addTest(new TestExamineAllHeaderBlocksWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.header.TestExamineHeaderBlocksWithParser(this.metaFactory));
        this.addTest(new TestExamineMustUnderstandHeaderBlocks(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.header.TestExamineMustUnderstandHeaderBlocksWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.header.TestGetHeaderBlocksWithNSURIWithParser(this.metaFactory));
        this.addTest(new org.apache.axiom.ts.soap12.header.TestGetHeadersToProcessWithParser(this.metaFactory));
    }
}

