/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.body;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import junit.framework.AssertionFailedError;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.impl.builder.CustomBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPModelBuilder;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public abstract class FirstElementNameWithParserTestCase
extends SOAPTestCase {
    protected final QName qname;
    private final boolean supportsOptimization;

    public FirstElementNameWithParserTestCase(OMMetaFactory metaFactory, SOAPSpec spec, QName qname, boolean supportsOptimization) {
        super(metaFactory, spec);
        this.qname = qname;
        this.addTestProperty("prefix", qname.getPrefix());
        this.addTestProperty("uri", qname.getNamespaceURI());
        this.addTestProperty("localName", qname.getLocalPart());
        this.supportsOptimization = supportsOptimization;
    }

    protected final void runTest() throws Throwable {
        SOAPEnvelope orgEnvelope = this.soapFactory.getDefaultEnvelope();
        orgEnvelope.getBody().addChild((OMNode)this.soapFactory.createOMElement(this.qname.getLocalPart(), this.qname.getNamespaceURI(), this.qname.getPrefix()));
        SOAPModelBuilder builder = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Reader)new StringReader(orgEnvelope.toString()));
        if (this.supportsOptimization) {
            ((StAXSOAPModelBuilder)builder).registerCustomBuilderForPayload(new CustomBuilder(){

                public OMElement create(String namespace, String localPart, OMContainer parent, XMLStreamReader reader, OMFactory factory) throws OMException {
                    throw new AssertionFailedError("Custom builder called.");
                }
            });
        }
        this.runTest(builder.getSOAPEnvelope().getBody());
    }

    protected abstract void runTest(SOAPBody var1) throws Throwable;
}

