/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.builder;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.apache.axiom.om.AbstractTestCase;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.soap.builder.OMTestUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;

public class MessageTest
extends AxiomTestCase {
    private final String file;

    public MessageTest(OMMetaFactory metaFactory, String file) {
        super(metaFactory);
        this.file = file;
        this.addTestProperty("file", file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        Document expected;
        SOAPEnvelope soapEnvelope = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (InputStream)AbstractTestCase.getTestResource((String)this.file), null).getSOAPEnvelope();
        OMTestUtils.walkThrough((OMElement)soapEnvelope);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputStream in = AbstractTestCase.getTestResource((String)this.file);
        try {
            expected = db.parse(in);
        }
        finally {
            in.close();
        }
        Document actual = db.newDocument();
        TransformerFactory.newInstance().newTransformer().transform(soapEnvelope.getSAXSource(true), new DOMResult(actual));
        XMLAssert.assertXMLIdentical((Diff)XMLUnit.compareXML((Document)expected, (Document)actual), (boolean)true);
        soapEnvelope.close(false);
    }
}

