/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.envelope;

import java.util.Iterator;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.soap.SOAPCloneOptions;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;

public abstract class CloneTestCase
extends SOAPTestCase {
    public CloneTestCase(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void copyAndCheck(SOAPEnvelope sourceEnv) throws Exception {
        SOAPCloneOptions options = new SOAPCloneOptions();
        options.setFetchDataHandlers(true);
        options.setPreserveModel(true);
        options.setCopyOMDataSources(true);
        SOAPEnvelope targetEnv = (SOAPEnvelope)sourceEnv.clone((OMCloneOptions)options);
        this.identityCheck((OMNode)sourceEnv, (OMNode)targetEnv, "");
        String sourceText = sourceEnv.toString();
        String targetText = targetEnv.toString();
        XMLAssert.assertXMLIdentical((Diff)XMLUnit.compareXML((String)sourceText, (String)targetText), (boolean)true);
        sourceEnv.close(false);
    }

    protected void identityCheck(OMNode source, OMNode target, String depth) {
        if (source instanceof OMElement) {
            if (source instanceof OMSourcedElement) {
                CloneTestCase.assertTrue((String)("Source = " + source.getClass().getName() + "Target = " + target.getClass().getName()), (boolean)(target instanceof OMSourcedElement));
                CloneTestCase.assertEquals((boolean)((OMSourcedElement)source).isExpanded(), (boolean)((OMSourcedElement)target).isExpanded());
                if (((OMSourcedElement)source).isExpanded()) {
                    Iterator i = ((OMElement)source).getChildren();
                    Iterator j = ((OMElement)target).getChildren();
                    while (i.hasNext() && j.hasNext()) {
                        OMNode sourceChild = (OMNode)i.next();
                        OMNode targetChild = (OMNode)j.next();
                        this.identityCheck(sourceChild, targetChild, depth + "  ");
                    }
                    CloneTestCase.assertEquals((String)"Source and Target have different number of children", (boolean)i.hasNext(), (boolean)j.hasNext());
                }
            } else {
                CloneTestCase.assertEquals(source.getClass(), target.getClass());
                Iterator i = ((OMElement)source).getChildren();
                Iterator j = ((OMElement)target).getChildren();
                while (i.hasNext() && j.hasNext()) {
                    OMNode sourceChild = (OMNode)i.next();
                    OMNode targetChild = (OMNode)j.next();
                    this.identityCheck(sourceChild, targetChild, depth + "  ");
                }
                CloneTestCase.assertEquals((String)"Source and Target have different number of children", (boolean)i.hasNext(), (boolean)j.hasNext());
            }
        } else {
            CloneTestCase.assertEquals(source.getClass(), target.getClass());
        }
    }
}

