/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.envelope;

import java.io.Reader;
import java.io.StringReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestGetSOAPBodyFirstElementLocalNameAndNSWithParser
extends SOAPTestCase {
    private final QName qname;

    public TestGetSOAPBodyFirstElementLocalNameAndNSWithParser(OMMetaFactory metaFactory, SOAPSpec spec, QName qname) {
        super(metaFactory, spec);
        this.qname = qname;
        this.addTestProperty("prefix", qname.getPrefix());
        this.addTestProperty("uri", qname.getNamespaceURI());
    }

    protected void runTest() throws Throwable {
        SOAPFactory factory = this.spec.getFactory(this.metaFactory);
        SOAPEnvelope orgEnvelope = factory.getDefaultEnvelope();
        orgEnvelope.getBody().addChild((OMNode)this.soapFactory.createOMElement(this.qname.getLocalPart(), this.qname.getNamespaceURI(), this.qname.getPrefix()));
        String message = orgEnvelope.toString();
        SOAPEnvelope envelope = OMXMLBuilderFactory.createSOAPModelBuilder((OMMetaFactory)this.metaFactory, (Reader)new StringReader(message)).getSOAPEnvelope();
        TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)this.qname.getLocalPart(), (String)envelope.getSOAPBodyFirstElementLocalName());
        OMNamespace ns = envelope.getSOAPBodyFirstElementNS();
        if (this.qname.getNamespaceURI().length() == 0) {
            TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertNull((Object)ns);
        } else {
            TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)this.qname.getNamespaceURI(), (String)ns.getNamespaceURI());
            TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)this.qname.getPrefix(), (String)ns.getPrefix());
        }
        XMLStreamReader reader = envelope.getXMLStreamReader(false);
        TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((int)1, (int)reader.next());
        TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)"Envelope", (String)reader.getLocalName());
        TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((int)1, (int)reader.next());
        TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)"Body", (String)reader.getLocalName());
        TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((int)1, (int)reader.next());
        TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)this.qname.getLocalPart(), (String)reader.getLocalName());
        if (this.qname.getNamespaceURI().length() == 0) {
            TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertNull((Object)reader.getNamespaceURI());
        } else {
            TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)this.qname.getNamespaceURI(), (String)reader.getNamespaceURI());
        }
        if (this.qname.getPrefix().length() == 0) {
            TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertNull((Object)reader.getPrefix());
        } else {
            TestGetSOAPBodyFirstElementLocalNameAndNSWithParser.assertEquals((String)this.qname.getPrefix(), (String)reader.getPrefix());
        }
    }
}

