/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.faultdetail;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestGetAllDetailEntries
extends SOAPTestCase {
    public TestGetAllDetailEntries(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.createSOAPEnvelope();
        SOAPBody body = this.soapFactory.createSOAPBody(envelope);
        SOAPFault fault = this.soapFactory.createSOAPFault(body);
        SOAPFaultDetail soapFaultDetail = this.soapFactory.createSOAPFaultDetail(fault);
        OMNamespace omNamespace = this.soapFactory.createOMNamespace("http://www.test.org", "test");
        Iterator iterator = soapFaultDetail.getAllDetailEntries();
        TestGetAllDetailEntries.assertFalse((String)"SOAP Fault Detail Test : - After creating SOAP11FaultDetail element, it has DetailEntries", (boolean)iterator.hasNext());
        soapFaultDetail.addDetailEntry(this.soapFactory.createOMElement("DetailEntry", omNamespace));
        iterator = soapFaultDetail.getAllDetailEntries();
        OMElement detailEntry = (OMElement)iterator.next();
        TestGetAllDetailEntries.assertNotNull((String)"SOAP Fault Detail Test : - After calling addDetailEntry method, getAllDetailEntries method returns empty iterator", (Object)detailEntry);
        TestGetAllDetailEntries.assertEquals((String)"SOAP Fault Detail Test : - detailEntry local name mismatch", (String)"DetailEntry", (String)detailEntry.getLocalName());
        TestGetAllDetailEntries.assertEquals((String)"SOAP Fault Detail Test : - detailEntry namespace uri mismatch", (String)"http://www.test.org", (String)detailEntry.getNamespace().getNamespaceURI());
        TestGetAllDetailEntries.assertFalse((String)"SOAP Fault Detail Test : - After calling addDetailEntry method once, getAllDetailEntries method returns an iterator with two objects", (boolean)iterator.hasNext());
    }
}

