/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.header.SOAPRoleTest;

public class TestGetHeadersToProcessWithNamespace
extends SOAPRoleTest {
    public TestGetHeadersToProcessWithNamespace(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader header = this.soapFactory.createSOAPHeader(envelope);
        OMNamespace ns1 = this.soapFactory.createOMNamespace("urn:ns1", "ns1");
        OMNamespace ns2 = this.soapFactory.createOMNamespace("urn:ns2", "ns2");
        String myRole = "urn:myRole";
        String otherRole = "urn:otherRole";
        SOAPHeaderBlock headerBlock1 = header.addHeaderBlock("header1", ns1);
        headerBlock1.setRole(myRole);
        SOAPHeaderBlock headerBlock2 = header.addHeaderBlock("header2", ns2);
        headerBlock2.setRole(myRole);
        SOAPHeaderBlock headerBlock3 = header.addHeaderBlock("header3", ns1);
        headerBlock3.setRole(myRole);
        SOAPHeaderBlock headerBlock4 = header.addHeaderBlock("header4", ns1);
        headerBlock4.setRole(otherRole);
        Iterator it = header.getHeadersToProcess((RolePlayer)new SOAPRoleTest.MyRolePlayer(false, new String[]{myRole}), ns1.getNamespaceURI());
        TestGetHeadersToProcessWithNamespace.assertTrue((boolean)it.hasNext());
        TestGetHeadersToProcessWithNamespace.assertSame((Object)headerBlock1, it.next());
        TestGetHeadersToProcessWithNamespace.assertTrue((boolean)it.hasNext());
        TestGetHeadersToProcessWithNamespace.assertSame((Object)headerBlock3, it.next());
        TestGetHeadersToProcessWithNamespace.assertFalse((boolean)it.hasNext());
    }
}

