/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.headerblock;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestSetMustUnderstandBoolean
extends SOAPTestCase {
    private final boolean value;
    private final String stringValue;

    public TestSetMustUnderstandBoolean(OMMetaFactory metaFactory, SOAPSpec spec, boolean value, String stringValue) {
        super(metaFactory, spec);
        this.addTestProperty("value", Boolean.toString(value));
        this.value = value;
        this.stringValue = stringValue;
    }

    protected void runTest() throws Throwable {
        SOAPHeaderBlock soapHeaderBlock = this.createSOAPHeaderBlock();
        soapHeaderBlock.setMustUnderstand(this.value);
        TestSetMustUnderstandBoolean.assertEquals((String)"getMustUnderstand return value", (boolean)this.value, (boolean)soapHeaderBlock.getMustUnderstand());
        Iterator it = soapHeaderBlock.getAllAttributes();
        TestSetMustUnderstandBoolean.assertTrue((boolean)it.hasNext());
        OMAttribute att = (OMAttribute)it.next();
        OMNamespace ns = att.getNamespace();
        TestSetMustUnderstandBoolean.assertEquals((String)this.spec.getEnvelopeNamespaceURI(), (String)ns.getNamespaceURI());
        TestSetMustUnderstandBoolean.assertEquals((String)"mustUnderstand", (String)att.getLocalName());
        TestSetMustUnderstandBoolean.assertEquals((String)this.stringValue, (String)att.getAttributeValue());
        TestSetMustUnderstandBoolean.assertFalse((boolean)it.hasNext());
    }
}

