/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.factory;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestCreateSOAPFaultSubCode
extends SOAPTestCase {
    public TestCreateSOAPFaultSubCode(OMMetaFactory metaFactory) {
        super(metaFactory, SOAPSpec.SOAP12);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.getDefaultFaultEnvelope();
        SOAPFault fault = envelope.getBody().getFault();
        SOAPFaultCode code = fault.getCode();
        SOAPFaultSubCode subCode = this.soapFactory.createSOAPFaultSubCode(code);
        TestCreateSOAPFaultSubCode.assertEquals((String)"http://www.w3.org/2003/05/soap-envelope", (String)subCode.getNamespaceURI());
        TestCreateSOAPFaultSubCode.assertEquals((String)"Subcode", (String)subCode.getLocalName());
        TestCreateSOAPFaultSubCode.assertSame((Object)code, (Object)subCode.getParent());
        Iterator it = code.getChildren();
        TestCreateSOAPFaultSubCode.assertTrue((boolean)it.hasNext());
        TestCreateSOAPFaultSubCode.assertTrue((boolean)(it.next() instanceof SOAPFaultValue));
        TestCreateSOAPFaultSubCode.assertTrue((boolean)it.hasNext());
        TestCreateSOAPFaultSubCode.assertSame((Object)subCode, it.next());
        TestCreateSOAPFaultSubCode.assertFalse((boolean)it.hasNext());
    }
}

