/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap12.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.RolePlayer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.header.SOAPRoleTest;

public class TestGetHeadersToProcessWithParser
extends SOAPRoleTest {
    public TestGetHeadersToProcessWithParser(OMMetaFactory metaFactory) {
        super(metaFactory, SOAPSpec.SOAP12);
    }

    protected void runTest() throws Throwable {
        SOAPHeaderBlock header;
        SOAPEnvelope env = this.getTestMessage("roleMessage.xml");
        SOAPHeader soapHeader = env.getHeader();
        String[] roles = new String[]{"http://example.org/myCustomRole"};
        SOAPRoleTest.MyRolePlayer rp = new SOAPRoleTest.MyRolePlayer(true, roles);
        Iterator headers = soapHeader.getHeadersToProcess((RolePlayer)rp);
        TestGetHeadersToProcessWithParser.assertTrue((String)"No headers!", (boolean)headers.hasNext());
        int numHeaders = 0;
        while (headers.hasNext()) {
            header = (SOAPHeaderBlock)headers.next();
            ++numHeaders;
        }
        TestGetHeadersToProcessWithParser.assertEquals((String)"Didn't get right number of headers (with custom role)", (int)5, (int)numHeaders);
        rp = new SOAPRoleTest.MyRolePlayer(true);
        headers = soapHeader.getHeadersToProcess((RolePlayer)rp);
        TestGetHeadersToProcessWithParser.assertTrue((boolean)headers.hasNext());
        numHeaders = 0;
        while (headers.hasNext()) {
            header = (SOAPHeaderBlock)headers.next();
            ++numHeaders;
        }
        TestGetHeadersToProcessWithParser.assertEquals((String)"Didn't get right number of headers (no custom role)", (int)4, (int)numHeaders);
        rp = new SOAPRoleTest.MyRolePlayer(false);
        headers = soapHeader.getHeadersToProcess((RolePlayer)rp);
        TestGetHeadersToProcessWithParser.assertTrue((boolean)headers.hasNext());
        numHeaders = 0;
        while (headers.hasNext()) {
            header = (SOAPHeaderBlock)headers.next();
            ++numHeaders;
        }
        TestGetHeadersToProcessWithParser.assertEquals((String)"Didn't get right number of headers (no custom role)", (int)1, (int)numHeaders);
        env.close(false);
    }
}

