/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.testutils.stax.XMLStreamReaderComparator;
import org.apache.axiom.testutils.suite.Dimension;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.CoalescingXMLFilter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class BuilderFactory
extends Multiton
implements Dimension {
    public static final BuilderFactory PARSER = new BuilderFactory(){

        @Override
        public boolean isDeferredParsing() {
            return true;
        }

        @Override
        public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
        }

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("source", "parser");
        }

        @Override
        public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
            return metaFactory.createOMBuilder(metaFactory.getOMFactory(), AxiomTestCase.TEST_PARSER_CONFIGURATION, inputSource);
        }
    };
    public static final BuilderFactory DOM = new BuilderFactory(){

        @Override
        public boolean isDeferredParsing() {
            return true;
        }

        @Override
        public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
            comparator.setCompareEntityReplacementValue(false);
            comparator.setSortAttributes(true);
        }

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("source", "dom");
        }

        @Override
        public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setExpandEntityReferences(false);
            Document document = dbf.newDocumentBuilder().parse(inputSource);
            return OMXMLBuilderFactory.createOMBuilder((OMFactory)metaFactory.getOMFactory(), (Node)document, (boolean)false);
        }
    };
    public static final BuilderFactory SAX = new BuilderFactory(){

        @Override
        public boolean isDeferredParsing() {
            return false;
        }

        @Override
        public void configureXMLStreamReaderComparator(XMLStreamReaderComparator comparator) {
            comparator.setCompareCharacterEncodingScheme(false);
            comparator.setCompareEncoding(false);
        }

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("source", "sax");
        }

        @Override
        public OMXMLParserWrapper getBuilder(OMMetaFactory metaFactory, InputSource inputSource) throws Exception {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            SAXParser parser = factory.newSAXParser();
            SAXSource source = new SAXSource(new CoalescingXMLFilter(parser.getXMLReader()), inputSource);
            return OMXMLBuilderFactory.createOMBuilder((OMFactory)metaFactory.getOMFactory(), (SAXSource)source, (boolean)false);
        }
    };

    private BuilderFactory() {
    }

    public abstract boolean isDeferredParsing();

    public abstract void configureXMLStreamReaderComparator(XMLStreamReaderComparator var1);

    public abstract OMXMLParserWrapper getBuilder(OMMetaFactory var1, InputSource var2) throws Exception;
}

