/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.dimension;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.testing.multiton.Multiton;
import org.apache.axiom.testutils.suite.Dimension;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public abstract class ElementContext
extends Multiton
implements Dimension {
    public static final ElementContext ORPHAN = new ElementContext(){

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("container", "none");
        }

        @Override
        public OMContainer wrap(OMElement element) {
            return null;
        }

        @Override
        public InputSource getControl(InputSource xml) {
            throw new UnsupportedOperationException();
        }
    };
    public static final ElementContext ELEMENT = new ElementContext(){

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("container", "element");
            testCase.addTestParameter("complete", true);
        }

        @Override
        public OMContainer wrap(OMElement element) {
            OMElement parent = element.getOMFactory().createOMElement("parent", null);
            parent.addChild((OMNode)element);
            return parent;
        }

        @Override
        public InputSource getControl(InputSource xml) throws Exception {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document document = dbf.newDocumentBuilder().parse(xml);
            Element parent = document.createElementNS(null, "parent");
            parent.appendChild(document.getDocumentElement());
            StringWriter sw = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(parent), new StreamResult(sw));
            return new InputSource(new StringReader(sw.toString()));
        }
    };
    public static final ElementContext INCOMPLETE_ELEMENT = new ElementContext(){

        public void addTestParameters(MatrixTestCase testCase) {
            testCase.addTestParameter("container", "element");
            testCase.addTestParameter("complete", "false");
        }

        @Override
        public OMContainer wrap(OMElement element) {
            OMElement parent = OMXMLBuilderFactory.createOMBuilder((OMFactory)element.getOMFactory(), (Reader)new StringReader("<parent><sibling/></parent>")).getDocumentElement();
            parent.getFirstOMChild().insertSiblingBefore((OMNode)element);
            Assert.assertFalse((boolean)parent.isComplete());
            return parent;
        }

        @Override
        public InputSource getControl(InputSource xml) throws Exception {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document document = dbf.newDocumentBuilder().parse(xml);
            Element parent = document.createElementNS(null, "parent");
            parent.appendChild(document.getDocumentElement());
            parent.appendChild(document.createElementNS(null, "sibling"));
            StringWriter sw = new StringWriter();
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(parent), new StreamResult(sw));
            return new InputSource(new StringReader(sw.toString()));
        }
    };

    private ElementContext() {
    }

    public abstract OMContainer wrap(OMElement var1);

    public abstract InputSource getControl(InputSource var1) throws Exception;
}

