/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.xml.XMLSample;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class TestCreateOMBuilderFromDOM
extends ConformanceTestCase {
    private final Boolean expandEntityReferences;

    public TestCreateOMBuilderFromDOM(OMMetaFactory metaFactory, XMLSample file, Boolean expandEntityReferences) {
        super(metaFactory, file);
        this.expandEntityReferences = expandEntityReferences;
        if (expandEntityReferences != null) {
            this.addTestParameter("expandEntityReferences", expandEntityReferences);
        }
    }

    protected void runTest() throws Throwable {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setExpandEntityReferences(false);
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        Document document = documentBuilder.parse(this.file.getUrl().toString());
        OMXMLParserWrapper builder = this.expandEntityReferences == null ? OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)new DOMSource(document)) : OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Node)document, (boolean)this.expandEntityReferences);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        builder.getDocument().serialize((OutputStream)baos);
        InputSource actual = new InputSource();
        actual.setByteStream(new ByteArrayInputStream(baos.toByteArray()));
        actual.setSystemId(this.file.getUrl().toString());
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)XMLTruth.xml((InputSource)actual))).ignoringWhitespaceInPrologAndEpilog().expandingEntityReferences(this.expandEntityReferences == null ? false : this.expandEntityReferences).hasSameContentAs(XMLTruth.xml((URL)this.file.getUrl()));
    }
}

