/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.truth.AxiomTestVerb;
import org.apache.axiom.ts.AxiomTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestDetachWithDOM
extends AxiomTestCase {
    private final boolean useDOMSource;

    public TestDetachWithDOM(OMMetaFactory metaFactory, boolean useDOMSource) {
        super(metaFactory);
        this.useDOMSource = useDOMSource;
        this.addTestParameter("useDOMSource", useDOMSource);
    }

    protected void runTest() throws Throwable {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = document.createElementNS("", "root");
        root.appendChild(document.createElementNS("", "a"));
        OMXMLParserWrapper builder = this.useDOMSource ? OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)new DOMSource(root)) : OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Node)root, (boolean)false);
        OMElement omRoot = builder.getDocumentElement();
        builder.detach();
        root.appendChild(document.createElementNS("", "b"));
        AxiomTestVerb.ASSERT.that(omRoot).hasNumberOfChildren(1);
    }
}

