/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import java.io.Closeable;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.testutils.io.InstrumentedStream;
import org.apache.axiom.truth.AxiomTestVerb;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.StreamTypeAdapter;
import org.apache.axiom.ts.xml.StreamType;
import org.apache.axiom.ts.xml.XMLSample;

public class TestDetachWithStream
extends AxiomTestCase {
    private final StreamType streamType;
    private final boolean useStreamSource;

    public TestDetachWithStream(OMMetaFactory metaFactory, StreamType streamType, boolean useStreamSource) {
        super(metaFactory);
        this.streamType = streamType;
        this.useStreamSource = useStreamSource;
        this.addTestParameter("streamType", streamType.getType().getSimpleName());
        this.addTestParameter("useStreamSource", useStreamSource);
    }

    protected final void runTest() throws Throwable {
        InstrumentedStream stream = this.streamType.instrumentStream(this.streamType.getStream(XMLSample.LARGE));
        OMXMLParserWrapper builder = this.useStreamSource ? OMXMLBuilderFactory.createOMBuilder((OMFactory)this.metaFactory.getOMFactory(), (Source)this.streamType.createStreamSource((Closeable)stream)) : ((StreamTypeAdapter)this.streamType.getAdapter(StreamTypeAdapter.class)).createOMBuilder(this.metaFactory.getOMFactory(), (Closeable)stream);
        long countBeforeDetach = stream.getCount();
        builder.detach();
        AxiomTestVerb.ASSERT.that(Long.valueOf(stream.getCount())).isGreaterThan((Comparable)Long.valueOf(countBeforeDetach));
        AxiomTestVerb.ASSERT.that(Boolean.valueOf(stream.isClosed())).isFalse();
        stream.close();
        builder.getDocument().build();
    }
}

