/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.builder;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.StringReader;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.BuilderFactory;
import org.xml.sax.InputSource;

public class TestGetDocumentElement
extends AxiomTestCase {
    private final BuilderFactory builderFactory;
    private final Boolean discardDocument;

    public TestGetDocumentElement(OMMetaFactory metaFactory, BuilderFactory builderFactory, Boolean discardDocument) {
        super(metaFactory);
        this.builderFactory = builderFactory;
        this.discardDocument = discardDocument;
        builderFactory.addTestParameters(this);
        this.addTestParameter("discardDocument", String.valueOf(discardDocument));
    }

    protected void runTest() throws Throwable {
        OMXMLParserWrapper builder = this.builderFactory.getBuilder(this.metaFactory, new InputSource(new StringReader("<!--comment1--><root/><!--comment2-->")));
        OMElement element = this.discardDocument == null ? builder.getDocumentElement() : builder.getDocumentElement(this.discardDocument.booleanValue());
        TestGetDocumentElement.assertNotNull((String)"Document element can not be null", (Object)element);
        TestGetDocumentElement.assertEquals((String)"Name of the document element is wrong", (String)"root", (String)element.getLocalName());
        if (Boolean.TRUE.equals(this.discardDocument)) {
            if (this.builderFactory.isDeferredParsing()) {
                TestGetDocumentElement.assertFalse((boolean)element.isComplete());
            }
            TestGetDocumentElement.assertNull((Object)element.getParent());
            TestGetDocumentElement.assertNull((Object)element.getPreviousOMSibling());
            OMElement newParent = element.getOMFactory().createOMElement("newParent", null);
            newParent.addChild((OMNode)element);
            if (this.builderFactory.isDeferredParsing()) {
                TestGetDocumentElement.assertFalse((boolean)element.isComplete());
                TestGetDocumentElement.assertFalse((boolean)builder.isCompleted());
            }
            ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)XMLTruth.xml((Object)newParent))).hasSameContentAs(XMLTruth.xml((String)"<newParent><root/></newParent>"));
            TestGetDocumentElement.assertTrue((boolean)element.isComplete());
            TestGetDocumentElement.assertTrue((boolean)builder.isCompleted());
        } else {
            TestGetDocumentElement.assertSame((Object)builder.getDocument(), (Object)element.getParent());
            TestGetDocumentElement.assertSame((Object)builder.getDocument().getOMDocumentElement(), (Object)element);
            TestGetDocumentElement.assertTrue((boolean)(element.getPreviousOMSibling() instanceof OMComment));
            TestGetDocumentElement.assertTrue((boolean)(element.getNextOMSibling() instanceof OMComment));
        }
    }
}

