/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.document;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.net.URL;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.testutils.suite.XSLTImplementation;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.ConformanceTestCase;
import org.apache.axiom.ts.xml.XMLSample;

public class TestGetSAXResult
extends ConformanceTestCase {
    private final XSLTImplementation xsltImplementation;

    public TestGetSAXResult(OMMetaFactory metaFactory, XSLTImplementation xsltImplementation, XMLSample file) {
        super(metaFactory, file);
        this.xsltImplementation = xsltImplementation;
        xsltImplementation.addTestParameters((MatrixTestCase)this);
    }

    protected void runTest() throws Throwable {
        TransformerFactory transformerFactory = this.xsltImplementation.newTransformerFactory();
        StreamSource source = new StreamSource(this.file.getUrl().toString());
        OMDocument document = this.metaFactory.getOMFactory().createOMDocument();
        SAXResult result = document.getSAXResult();
        transformerFactory.newTransformer().transform(source, result);
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)XMLTruth.xml((Object)document))).ignoringWhitespaceInPrologAndEpilog().ignoringRedundantNamespaceDeclarations().expandingEntityReferences().hasSameContentAs(XMLTruth.xml((URL)this.file.getUrl()));
    }
}

