/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.document.sr;

import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.ext.stax.DTDReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.ts.AxiomTestCase;

public class TestDTDReader
extends AxiomTestCase {
    public TestDTDReader(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMDocument document = factory.createOMDocument();
        factory.createOMDocType((OMContainer)document, "root", "-//MY//DTD", "my.dtd", "<!ELEMENT root (#PCDATA)>");
        factory.createOMElement("root", null, (OMContainer)document);
        XMLStreamReader reader = document.getXMLStreamReader();
        DTDReader dtdReader = (DTDReader)reader.getProperty(DTDReader.PROPERTY);
        TestDTDReader.assertNotNull((Object)dtdReader);
        TestDTDReader.assertEquals((int)11, (int)reader.next());
        TestDTDReader.assertEquals((String)"root", (String)dtdReader.getRootName());
        TestDTDReader.assertEquals((String)"-//MY//DTD", (String)dtdReader.getPublicId());
        TestDTDReader.assertEquals((String)"my.dtd", (String)dtdReader.getSystemId());
        TestDTDReader.assertEquals((String)"<!ELEMENT root (#PCDATA)>", (String)reader.getText());
    }
}

