/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.truth.AxiomTestVerb;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.AddAttributeStrategy;

public class TestAddAttributeReplace
extends AxiomTestCase {
    private final AddAttributeStrategy strategy;

    public TestAddAttributeReplace(OMMetaFactory metaFactory, AddAttributeStrategy strategy) {
        super(metaFactory);
        this.strategy = strategy;
        strategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMNamespace ns1 = factory.createOMNamespace("urn:ns", "p1");
        OMNamespace ns2 = factory.createOMNamespace("urn:ns", "p2");
        OMElement element = factory.createOMElement(new QName("test"));
        OMAttribute att1 = this.strategy.addAttribute(element, "test", ns1, "value1");
        OMAttribute att2 = this.strategy.addAttribute(element, "test", ns2, "value2");
        Iterator it = element.getAllAttributes();
        AxiomTestVerb.ASSERT.that(Boolean.valueOf(it.hasNext())).isTrue();
        AxiomTestVerb.ASSERT.that(it.next()).isSameAs((Object)att2);
        AxiomTestVerb.ASSERT.that(Boolean.valueOf(it.hasNext())).isFalse();
        AxiomTestVerb.ASSERT.that(att1.getOwner()).isNull();
        AxiomTestVerb.ASSERT.that(att2.getOwner()).isSameAs((Object)element);
        AxiomTestVerb.ASSERT.that(att1).hasValue("value1");
        AxiomTestVerb.ASSERT.that(att2).hasValue("value2");
    }
}

