/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import java.util.Iterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.AddAttributeStrategy;
import org.apache.axiom.ts.dimension.NoNamespaceStrategy;

public class TestAddAttributeWithoutNamespace
extends AxiomTestCase {
    private final AddAttributeStrategy addAttributeStrategy;
    private final NoNamespaceStrategy noNamespaceStrategy;

    public TestAddAttributeWithoutNamespace(OMMetaFactory metaFactory, AddAttributeStrategy addAttributeStrategy, NoNamespaceStrategy noNamespaceStrategy) {
        super(metaFactory);
        this.addAttributeStrategy = addAttributeStrategy;
        this.noNamespaceStrategy = noNamespaceStrategy;
        addAttributeStrategy.addTestParameters(this);
        noNamespaceStrategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement element = factory.createOMElement("test", "urn:test", "");
        OMNamespace ns = (OMNamespace)element.getAllDeclaredNamespaces().next();
        OMAttribute attr = this.addAttributeStrategy.addAttribute(element, "test", this.noNamespaceStrategy.createOMNamespace(factory), "test");
        TestAddAttributeWithoutNamespace.assertNull((Object)attr.getNamespace());
        Iterator it = element.getAllDeclaredNamespaces();
        TestAddAttributeWithoutNamespace.assertTrue((boolean)it.hasNext());
        TestAddAttributeWithoutNamespace.assertEquals((Object)ns, it.next());
        TestAddAttributeWithoutNamespace.assertFalse((boolean)it.hasNext());
    }
}

