/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.InputStream;
import javax.xml.transform.Transformer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.testutils.suite.MatrixTestCase;
import org.apache.axiom.testutils.suite.XSLTImplementation;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;

public class TestGetSAXSourceIdentityTransform
extends AxiomTestCase {
    private final XSLTImplementation xsltImplementation;
    private final boolean cache;

    public TestGetSAXSourceIdentityTransform(OMMetaFactory metaFactory, XSLTImplementation xsltImplementation, boolean cache) {
        super(metaFactory);
        this.xsltImplementation = xsltImplementation;
        this.cache = cache;
        xsltImplementation.addTestParameters((MatrixTestCase)this);
        this.addTestParameter("cache", cache);
    }

    private InputStream getInput() {
        return TestGetSAXSourceIdentityTransform.class.getResourceAsStream("test.xml");
    }

    protected void runTest() throws Throwable {
        Transformer transformer = this.xsltImplementation.newTransformerFactory().newTransformer();
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement element = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (InputStream)this.getInput()).getDocumentElement();
        OMDocument outputDocument = factory.createOMDocument();
        transformer.transform(element.getSAXSource(this.cache), outputDocument.getSAXResult());
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)XMLTruth.xml((Object)outputDocument))).ignoringWhitespaceInPrologAndEpilog().hasSameContentAs(XMLTruth.xml((InputStream)this.getInput()));
        element.close(false);
    }
}

