/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.element;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.Reader;
import java.io.StringReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;

public class TestRemoveChildren
extends AxiomTestCase {
    private final boolean complete;

    public TestRemoveChildren(OMMetaFactory metaFactory, boolean complete) {
        super(metaFactory);
        this.complete = complete;
        this.addTestParameter("complete", complete);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMElement element = OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader("<root><a>A</a><b>B</b></root>")).getDocumentElement();
        if (this.complete) {
            element.build();
        }
        OMElement firstChild = (OMElement)element.getFirstOMChild();
        TestRemoveChildren.assertEquals((boolean)this.complete, (boolean)element.isComplete());
        TestRemoveChildren.assertEquals((boolean)this.complete, (boolean)firstChild.isComplete());
        element.removeChildren();
        TestRemoveChildren.assertEquals((String)"A", (String)firstChild.getText());
        TestRemoveChildren.assertNull((Object)firstChild.getParent());
        TestRemoveChildren.assertNull((Object)firstChild.getPreviousOMSibling());
        TestRemoveChildren.assertNull((Object)firstChild.getNextOMSibling());
        TestRemoveChildren.assertNull((Object)element.getFirstOMChild());
        element.addChild((OMNode)factory.createOMElement("c", null));
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)XMLTruth.xml((Object)element))).hasSameContentAs(XMLTruth.xml((String)"<root><c/></root>"));
    }
}

