/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.node;

import java.io.Reader;
import java.io.StringReader;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.ts.AxiomTestCase;

public class TestDetach
extends AxiomTestCase {
    private final boolean document;
    private final boolean build;

    public TestDetach(OMMetaFactory metaFactory, boolean document, boolean build) {
        super(metaFactory);
        this.document = document;
        this.build = build;
        this.addTestParameter("document", document);
        this.addTestParameter("build", build);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        Object root = this.document ? OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader("<!--a--><b/><!--c-->")).getDocument() : OMXMLBuilderFactory.createOMBuilder((OMFactory)factory, (Reader)new StringReader("<root><!--a--><b/><!--c--></root>")).getDocumentElement();
        if (this.build) {
            root.build();
        } else {
            TestDetach.assertFalse((boolean)root.isComplete());
        }
        OMComment a = (OMComment)root.getFirstOMChild();
        TestDetach.assertEquals((String)"a", (String)a.getValue());
        OMElement b = (OMElement)a.getNextOMSibling();
        TestDetach.assertEquals((String)"b", (String)b.getLocalName());
        OMNode returnValue = b.detach();
        TestDetach.assertSame((Object)b, (Object)returnValue);
        TestDetach.assertNull((Object)b.getParent());
        TestDetach.assertNull((Object)b.getPreviousOMSibling());
        TestDetach.assertNull((Object)b.getNextOMSibling());
        OMComment c = (OMComment)a.getNextOMSibling();
        TestDetach.assertEquals((String)"c", (String)c.getValue());
        TestDetach.assertSame((Object)c, (Object)a.getNextOMSibling());
        TestDetach.assertSame((Object)a, (Object)c.getPreviousOMSibling());
        root.close(false);
    }
}

