/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.ts.AxiomTestCase;

public class TestCloneUnknownName
extends AxiomTestCase {
    public TestCloneUnknownName(OMMetaFactory metaFactory) {
        super(metaFactory);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        ByteArrayDataSource ds = new ByteArrayDataSource("<p:element xmlns:p='urn:ns'>test</p:element>".getBytes("utf-8"), "utf-8");
        OMSourcedElement element = factory.createOMElement((OMDataSource)ds);
        OMCloneOptions options = new OMCloneOptions();
        options.setCopyOMDataSources(true);
        OMElement clone = (OMElement)element.clone(options);
        TestCloneUnknownName.assertTrue((boolean)(clone instanceof OMSourcedElement));
        TestCloneUnknownName.assertFalse((boolean)element.isExpanded());
        OMNamespace expectedNS = factory.createOMNamespace("urn:ns", "p");
        TestCloneUnknownName.assertEquals((String)"element", (String)element.getLocalName());
        TestCloneUnknownName.assertEquals((String)"element", (String)clone.getLocalName());
        TestCloneUnknownName.assertEquals((Object)expectedNS, (Object)element.getNamespace());
        TestCloneUnknownName.assertEquals((Object)expectedNS, (Object)clone.getNamespace());
    }
}

