/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.StringReader;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.ElementContext;
import org.apache.axiom.ts.dimension.ExpansionStrategy;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.dimension.serialization.XML;
import org.apache.axiom.ts.om.sourcedelement.TestDocument;
import org.apache.axiom.ts.om.sourcedelement.util.PullOMDataSource;
import org.xml.sax.InputSource;

public class TestSerialize
extends AxiomTestCase {
    private final boolean push;
    private final boolean destructive;
    private final ElementContext elementContext;
    private final ExpansionStrategy expansionStrategy;
    private final SerializationStrategy serializationStrategy;
    private final boolean serializeParent;
    private final int count;

    public TestSerialize(OMMetaFactory metaFactory, boolean push, boolean destructive, ElementContext elementContext, ExpansionStrategy expansionStrategy, SerializationStrategy serializationStrategy, boolean serializeParent, int count) {
        super(metaFactory);
        this.push = push;
        this.destructive = destructive;
        this.elementContext = elementContext;
        this.expansionStrategy = expansionStrategy;
        this.serializationStrategy = serializationStrategy;
        this.serializeParent = serializeParent;
        this.count = count;
        this.addTestParameter("push", push);
        this.addTestParameter("destructive", destructive);
        elementContext.addTestParameters(this);
        expansionStrategy.addTestParameters(this);
        serializationStrategy.addTestParameters(this);
        this.addTestParameter("serializeParent", serializeParent);
        this.addTestParameter("count", count);
    }

    protected void runTest() throws Throwable {
        OMFactory factory = this.metaFactory.getOMFactory();
        OMSourcedElement element = TestDocument.DOCUMENT1.createOMSourcedElement(factory, this.push, this.destructive);
        OMDataSource ds = element.getDataSource();
        OMContainer parent = this.elementContext.wrap((OMElement)element);
        boolean parentComplete = parent != null && parent.isComplete();
        this.expansionStrategy.apply((OMContainer)element);
        boolean consuming = this.expansionStrategy.isConsumedAfterSerialization(this.push, this.destructive, this.serializationStrategy);
        for (int iteration = 0; iteration < this.count; ++iteration) {
            XML result;
            boolean expectException = iteration != 0 && (consuming || this.serializeParent && !this.serializationStrategy.isCaching() && !parentComplete);
            try {
                result = this.serializationStrategy.serialize((OMContainer)(this.serializeParent ? parent : element));
                if (expectException) {
                    TestSerialize.fail((String)"Expected exception");
                }
            }
            catch (Exception ex) {
                if (expectException) continue;
                throw ex;
            }
            InputSource expectedXML = new InputSource(new StringReader(TestDocument.DOCUMENT1.getContent()));
            if (this.serializeParent) {
                expectedXML = this.elementContext.getControl(expectedXML);
            }
            ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)XMLTruth.xml((InputSource)result.getInputSource()))).hasSameContentAs(XMLTruth.xml((InputSource)expectedXML));
            if (this.expansionStrategy.isExpandedAfterSerialization(this.push, this.destructive, this.serializationStrategy)) {
                TestSerialize.assertTrue((boolean)element.isExpanded());
                TestSerialize.assertEquals((String)"OMSourcedElement completion status", (!consuming ? 1 : 0) != 0, (boolean)element.isComplete());
            } else {
                TestSerialize.assertFalse((boolean)element.isExpanded());
            }
            if (parent == null || this.serializeParent) continue;
            TestSerialize.assertEquals((String)"Parent completion status", (boolean)parentComplete, (boolean)parent.isComplete());
        }
        if (ds instanceof PullOMDataSource) {
            TestSerialize.assertFalse((boolean)((PullOMDataSource)ds).hasUnclosedReaders());
        }
    }
}

