/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement;

import com.google.common.truth.SubjectFactory;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMSourcedElement;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.truth.xml.XMLSubject;
import org.apache.axiom.truth.xml.XMLTruth;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.dimension.serialization.SerializeToOutputStream;
import org.xml.sax.InputSource;

public class TestSerializeOMDataSourceWritingToOutputStream
extends AxiomTestCase {
    private final SerializationStrategy serializationStrategy;
    private final boolean serializeParent;

    public TestSerializeOMDataSourceWritingToOutputStream(OMMetaFactory metaFactory, SerializationStrategy serializationStrategy, boolean serializeParent) {
        super(metaFactory);
        this.serializationStrategy = serializationStrategy;
        this.serializeParent = serializeParent;
        serializationStrategy.addTestParameters(this);
        this.addTestParameter("serializeParent", serializeParent);
    }

    protected void runTest() throws Throwable {
        OMSourcedElement elementToSerialize;
        OMDataSourceImpl ds = new OMDataSourceImpl();
        OMFactory factory = this.metaFactory.getOMFactory();
        OMSourcedElement element = factory.createOMElement((OMDataSource)ds);
        if (this.serializeParent) {
            OMElement parent = factory.createOMElement("root", null);
            parent.addChild((OMNode)element);
            elementToSerialize = parent;
        } else {
            elementToSerialize = element;
        }
        ((XMLSubject)Truth.assertAbout((SubjectFactory)XMLTruth.xml()).that((Object)XMLTruth.xml((InputSource)this.serializationStrategy.serialize((OMContainer)elementToSerialize).getInputSource()))).hasSameContentAs(XMLTruth.xml((String)(this.serializeParent ? "<root><test xmlns='urn:test'/></root>" : "<test xmlns='urn:test'/>")));
        Truth.assertThat((Boolean)ds.isOutputStreamUsed()).isEqualTo((Object)(this.serializationStrategy instanceof SerializeToOutputStream));
    }

    private static final class OMDataSourceImpl
    extends AbstractPushOMDataSource {
        private boolean outputStreamUsed;

        private OMDataSourceImpl() {
        }

        public void serialize(XMLStreamWriter writer) throws XMLStreamException {
            String encoding;
            OutputStream out;
            if (writer instanceof MTOMXMLStreamWriter) {
                MTOMXMLStreamWriter writer2 = (MTOMXMLStreamWriter)writer;
                out = writer2.getOutputStream();
                encoding = writer2.getCharSetEncoding();
            } else {
                out = null;
                encoding = null;
            }
            if (out != null) {
                try {
                    out.write("<test xmlns=\"urn:test\"/>".getBytes(encoding));
                }
                catch (IOException ex) {
                    throw new XMLStreamException(ex);
                }
                this.outputStreamUsed = true;
            } else {
                writer.writeStartElement("", "test", "urn:test");
                writer.writeNamespace("", "urn:test");
                writer.writeEndElement();
            }
        }

        public boolean isDestructiveWrite() {
            return false;
        }

        boolean isOutputStreamUsed() {
            return this.outputStreamUsed;
        }
    }
}

