/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.sourcedelement.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.ds.AbstractPullOMDataSource;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.ts.om.sourcedelement.util.CloseTestXMLStreamReaderWrapper;

public final class PullOMDataSource
extends AbstractPullOMDataSource {
    private final String data;
    private final boolean destructive;
    private final Set unclosedReaders = new HashSet();
    private boolean destroyed;

    public PullOMDataSource(String data) {
        this(data, true);
    }

    public PullOMDataSource(String data, boolean destructive) {
        this.data = data;
        this.destructive = destructive;
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        if (this.destroyed) {
            throw new IllegalStateException("The OMDataSource has already been consumed");
        }
        if (this.destructive) {
            this.destroyed = true;
        }
        CloseTestXMLStreamReaderWrapper reader = new CloseTestXMLStreamReaderWrapper(this, StAXUtils.createXMLStreamReader((Reader)new StringReader(this.data)));
        this.unclosedReaders.add(reader);
        return reader;
    }

    public boolean isDestructiveRead() {
        return this.destructive;
    }

    public boolean hasUnclosedReaders() {
        return !this.unclosedReaders.isEmpty();
    }

    void readerClosed(CloseTestXMLStreamReaderWrapper reader) {
        this.unclosedReaders.remove((Object)reader);
    }
}

