/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.om.text;

import java.io.ByteArrayInputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.testutils.activation.RandomDataSource;
import org.apache.axiom.ts.AxiomTestCase;
import org.apache.axiom.ts.om.text.DummyMimePartProvider;
import org.apache.axiom.util.stax.xop.MimePartProvider;
import org.xml.sax.InputSource;

public class TestCloneBinary
extends AxiomTestCase {
    private boolean fetch;

    public TestCloneBinary(OMMetaFactory metaFactory, boolean fetch) {
        super(metaFactory);
        this.fetch = fetch;
        this.addTestParameter("fetch", fetch);
    }

    protected void runTest() throws Throwable {
        DataHandler dh = new DataHandler((DataSource)new RandomDataSource(600613L, 4096L));
        ByteArrayInputStream rootPart = new ByteArrayInputStream("<root><xop:Include xmlns:xop='http://www.w3.org/2004/08/xop/include' href='cid:123456@example.org'/></root>".getBytes("utf-8"));
        DummyMimePartProvider mimePartProvider = new DummyMimePartProvider("123456@example.org", dh);
        OMElement root = this.metaFactory.createOMBuilder(StAXParserConfiguration.DEFAULT, this.metaFactory.getOMFactory(), new InputSource(rootPart), (MimePartProvider)mimePartProvider).getDocumentElement();
        OMText text = (OMText)root.getFirstOMChild();
        OMCloneOptions options = new OMCloneOptions();
        options.setFetchDataHandlers(this.fetch);
        OMText clone = (OMText)text.clone(options);
        TestCloneBinary.assertTrue((boolean)clone.isBinary());
        TestCloneBinary.assertEquals((boolean)this.fetch, (boolean)mimePartProvider.isLoaded());
        TestCloneBinary.assertSame((Object)dh, (Object)clone.getDataHandler());
    }
}

