/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.fault;

import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axiom.ts.dimension.serialization.SerializationStrategy;
import org.apache.axiom.ts.soap.SOAPElementTypeAdapter;
import org.apache.axiom.ts.soap.SOAPFaultChild;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestChildOrder
extends SOAPTestCase {
    private final SOAPFaultChild[] inputOrder;
    private final SerializationStrategy serializationStrategy;

    public TestChildOrder(OMMetaFactory metaFactory, SOAPSpec spec, SOAPFaultChild[] inputOrder, SerializationStrategy serializationStrategy) {
        super(metaFactory, spec);
        this.inputOrder = inputOrder;
        this.serializationStrategy = serializationStrategy;
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < inputOrder.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(((SOAPElementTypeAdapter)inputOrder[i].getAdapter(SOAPElementTypeAdapter.class)).getType().getSimpleName());
        }
        this.addTestParameter("inputOrder", buffer.toString());
        serializationStrategy.addTestParameters(this);
    }

    protected void runTest() throws Throwable {
        SOAPFault fault = this.soapFactory.createSOAPFault();
        for (int i = 0; i < this.inputOrder.length; ++i) {
            SOAPElementTypeAdapter adapter = (SOAPElementTypeAdapter)this.inputOrder[i].getAdapter(SOAPElementTypeAdapter.class);
            adapter.getSetter().invoke((OMElement)fault, adapter.create(this.soapFactory));
        }
        TreeSet<SOAPFaultChild> outputOrder = new TreeSet<SOAPFaultChild>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((SOAPFaultChild)o1).getOrder() - ((SOAPFaultChild)o2).getOrder();
            }
        });
        outputOrder.addAll(Arrays.asList(this.inputOrder));
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document document = dbf.newDocumentBuilder().parse(this.serializationStrategy.serialize((OMContainer)fault).getInputSource());
        Element domFault = document.getDocumentElement();
        Node child = domFault.getFirstChild();
        for (SOAPFaultChild type : outputOrder) {
            TestChildOrder.assertNotNull((Object)child);
            TestChildOrder.assertEquals((String)type.getQName(this.spec).getLocalPart(), (String)child.getLocalName());
            child = child.getNextSibling();
        }
        TestChildOrder.assertNull((Object)child);
    }
}

