/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestExamineHeaderBlocks
extends SOAPTestCase {
    public TestExamineHeaderBlocks(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        String roleNextURI = this.spec.getNextRoleURI();
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        OMNamespace namespace = this.soapFactory.createOMNamespace("http://www.example.org", "test");
        soapHeader.addHeaderBlock("echoOk1", namespace).setRole("urn:test-role");
        soapHeader.addHeaderBlock("echoOk2", namespace).setRole(roleNextURI);
        Iterator iterator = soapHeader.examineHeaderBlocks(roleNextURI);
        iterator.hasNext();
        SOAPHeaderBlock headerBlockWithRole = (SOAPHeaderBlock)iterator.next();
        TestExamineHeaderBlocks.assertEquals((String)"SOAP Header Test : - headerBlockWithRole local name mismatch", (String)"echoOk2", (String)headerBlockWithRole.getLocalName());
        TestExamineHeaderBlocks.assertEquals((String)"SOAP Header Test : - headerBlockWithRole role value mismatch", (String)roleNextURI, (String)headerBlockWithRole.getRole());
        TestExamineHeaderBlocks.assertFalse((String)"SOAP Header Test : - header has one headerBlock with role, but examineHeaderBlocks(String role) method returns an iterator with more than one object", (boolean)iterator.hasNext());
    }
}

