/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.header;

import java.util.Iterator;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestExtractAllHeaderBlocks
extends SOAPTestCase {
    public TestExtractAllHeaderBlocks(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope envelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader header = this.soapFactory.createSOAPHeader(envelope);
        OMNamespace ns = this.soapFactory.createOMNamespace("urn:ns", "p");
        SOAPHeaderBlock h1 = header.addHeaderBlock("header1", ns);
        SOAPHeaderBlock h2 = header.addHeaderBlock("header2", ns);
        Iterator it = header.extractAllHeaderBlocks();
        TestExtractAllHeaderBlocks.assertTrue((boolean)it.hasNext());
        TestExtractAllHeaderBlocks.assertSame((Object)h1, it.next());
        TestExtractAllHeaderBlocks.assertTrue((boolean)it.hasNext());
        TestExtractAllHeaderBlocks.assertSame((Object)h2, it.next());
        TestExtractAllHeaderBlocks.assertFalse((boolean)it.hasNext());
    }
}

