/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.ts.soap.headerblock;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMDataSourceExt;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.ds.ByteArrayDataSource;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.ts.soap.SOAPSpec;
import org.apache.axiom.ts.soap.SOAPTestCase;

public class TestByteArrayDS
extends SOAPTestCase {
    public TestByteArrayDS(OMMetaFactory metaFactory, SOAPSpec spec) {
        super(metaFactory, spec);
    }

    protected void runTest() throws Throwable {
        SOAPEnvelope soapEnvelope = this.soapFactory.createSOAPEnvelope();
        SOAPHeader soapHeader = this.soapFactory.createSOAPHeader(soapEnvelope);
        String localName = "myPayload";
        String encoding = "utf-8";
        String payload1 = "<tns:myPayload xmlns:tns=\"urn://test\">Payload One</tns:myPayload>";
        OMNamespace ns = this.soapFactory.createOMNamespace("urn://test", "tns");
        ByteArrayDataSource bads1 = new ByteArrayDataSource(payload1.getBytes(encoding), encoding);
        bads1.setProperty("org.apache.axiom.soap.SOAPHeader.MUST_UNDERSTAND", null);
        SOAPHeaderBlock omse = this.soapFactory.createSOAPHeaderBlock(localName, ns, (OMDataSource)bads1);
        soapHeader.addChild((OMNode)omse);
        OMNode firstChild = soapHeader.getFirstOMChild();
        TestByteArrayDS.assertTrue((String)"Expected OMSourcedElement child", (boolean)(firstChild instanceof SOAPHeaderBlock));
        SOAPHeaderBlock child = (SOAPHeaderBlock)firstChild;
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestByteArrayDS.assertTrue((String)"OMSourcedElement should be backed by a ByteArrayDataSource", (boolean)(child.getDataSource() instanceof ByteArrayDataSource));
        TestByteArrayDS.assertTrue((!child.getMustUnderstand() ? 1 : 0) != 0);
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        TestByteArrayDS.assertTrue((String)"OMSourcedElement should be backed by a ByteArrayDataSource", (boolean)(child.getDataSource() instanceof ByteArrayDataSource));
        XMLStreamReader reader = child.getXMLStreamReader();
        reader.next();
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        soapHeader.serialize((OutputStream)baos);
        String output = baos.toString(encoding);
        TestByteArrayDS.assertTrue((String)"The payload was not present in the output", (output.indexOf(payload1) > 0 ? 1 : 0) != 0);
        TestByteArrayDS.assertTrue((String)"OMSourcedElement is expanded.  This is unexpected", (!child.isExpanded() ? 1 : 0) != 0);
        OMDataSourceExt ds = (OMDataSourceExt)child.getDataSource();
        byte[] bytes = ds.getXMLBytes("UTF-16");
        String payload = new String(bytes, "utf-16");
        TestByteArrayDS.assertTrue((String)"The obtained bytes did not match the payload", (boolean)payload1.equals(payload));
    }
}

